<?php

spl_autoload_register(function ($mod) {
    require('../../../../..//asset/mod/' . $mod . '.php');
});

// Load file autoload.php
require '../../../../../asset/bootstrap/asset/phpspreadsheet/autoload.php';


$tahun = $_GET['tahun'];
$tahun_tabel = substr($tahun, 2, 2) . substr($tahun, 7, 2);
$tb_siswa = "tb_siswa" . $tahun_tabel;
$tabungan_siswa = "tabungan_siswa" . $tahun_tabel;
$tabungan_transaksi = "tabungan_transaksi" . $tahun_tabel;



// Include librari PhpSpreadsheet
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();

// Buat sebuah variabel untuk menampung pengaturan style dari header tabel
$style_col = [
    'font' => ['bold' => true], // Set font nya jadi bold
    'font-family' => ['Arial'], // Set font nya jadi bold
    'alignment' => [
        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER, // Set text jadi ditengah secara horizontal (center)
        'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER // Set text jadi di tengah secara vertical (middle)
    ],
    'borders' => [
        'top' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN], // Set border top dengan garis tipis
        'right' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN],  // Set border right dengan garis tipis
        'bottom' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN], // Set border bottom dengan garis tipis
        'left' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN] // Set border left dengan garis tipis
    ]
];

// Buat sebuah variabel untuk menampung pengaturan style dari isi tabel
$style_row = [
    'alignment' => [
        'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER // Set text jadi di tengah secara vertical (middle)
    ],
    'borders' => [
        'top' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN], // Set border top dengan garis tipis
        'right' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN],  // Set border right dengan garis tipis
        'bottom' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN], // Set border bottom dengan garis tipis
        'left' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN] // Set border left dengan garis tipis
    ]
];
$clsCrud = new crudData;
$countData = $clsCrud->countData($tabungan_siswa, '') + 2;

$sheet->getStyle('A1')->getFont()->setBold(true); // Set bold kolom A1
$sheet->getStyle('A1')->getFont()->setSize(15); // Set font size 15 untuk kolom A1
$sheet->getStyle('A1:J' . $countData)->getFont()->setName('Arial');

//set auto colom
//for ($i = 'A'; $i !=  $sheet->getHighestColumn(); $i++) {
//    $sheet->getColumnDimension($i)->setAutoSize(TRUE);
//}


// Buat header tabel nya pada baris ke 3
$sheet->setCellValue('A1', 'NO');
$sheet->setCellValue('B1', 'NAMA');
$sheet->setCellValue('C1', 'NIS');
$sheet->setCellValue('D1', 'L/P');
$sheet->setCellValue('E1', 'KELAS');
$sheet->setCellValue('F1', 'SALDO AWAL');
$sheet->setCellValue('G1', 'DEBET');
$sheet->setCellValue('H1', 'KREDIT');
$sheet->setCellValue('I1', 'SALDO AKHIR');
$sheet->setCellValue('J1', 'STATUS');

// Apply style header yang telah kita buat tadi ke masing-masing kolom header
$sheet->getStyle('A1:J1')->applyFromArray($style_col);


$spreadsheet->getActiveSheet()->getStyle('A1:J1')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB('d5dbdb');

// Set height baris ke 1, 2 dan 3
$sheet->getRowDimension('1')->setRowHeight(20);


// Buat query untuk menampilkan semua data siswa
$showSiswa = $clsCrud->showTable($tabungan_siswa . " order by nama asc");
$no = 1;
$row = 2;
while ($data = $showSiswa->fetch(PDO::FETCH_OBJ)) {
    //count tabel siswa
    $count = $clsCrud->countData($tb_siswa, " where nis='$data->nis'");
    if ($count > 0) {
        $kelas = $clsCrud->getValue($tb_siswa, " where nis='$data->nis'", 'jenjang') . "-" . $clsCrud->getValue($tb_siswa, " where nis='$data->nis'", 'paralel');
    } else {
        $kelas = "--";
    };

    $clsTabungan = new tabungan;
    $jmlDebet = $clsTabungan->sumByID($tabungan_transaksi, 'D', 'nis', $data->nis);
    $jmlKredit = $clsTabungan->sumByID($tabungan_transaksi, 'K', 'nis', $data->nis);

    $saldoAkhir = @($data->saldo) + $jmlDebet - $jmlKredit;

    $sheet->setCellValue('A' . $row, $no);
    $sheet->setCellValue('B' . $row, $data->nama);
    $sheet->setCellValue('C' . $row, $data->nis);
    $sheet->setCellValue('D' . $row, $data->kelamin);
    $sheet->setCellValue('E' . $row, $kelas);
    $sheet->setCellValue('F' . $row, $data->saldo);
    $sheet->setCellValue('G' . $row, $jmlDebet);
    $sheet->setCellValue('H' . $row, $jmlKredit);
    $sheet->setCellValue('I' . $row, $saldoAkhir);
    $sheet->setCellValue('J' . $row, $data->status);

    $sheet->getStyle('A' . $row . ':J' . $row)->applyFromArray($style_row);

    $sheet->getStyle('A' . $row)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
    $sheet->getStyle('B' . $row)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT);
    $sheet->getStyle('C' . $row)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
    $sheet->getStyle('D' . $row)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
    $sheet->getStyle('E' . $row)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
    $sheet->getStyle('F' . $row)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
    $sheet->getStyle('G' . $row)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
    $sheet->getStyle('H' . $row)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
    $sheet->getStyle('I' . $row)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
    $sheet->getStyle('J' . $row)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT);

    $sheet->getRowDimension($row)->setRowHeight(20); // Set height tiap row


    $sheet->getStyle('E' . $row . ':I' . $countData)
        ->getNumberFormat()
        ->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_NUMBER);


    $no++; // Tambah 1 setiap kali looping
    $row++; // Tambah 1 setiap kali looping
};

//Jumlah
$sheet->setCellValue('A' . $countData, '');
$sheet->setCellValue('B' . $countData, 'JUMLAH');
$sheet->setCellValue('C' . $countData, '');
$sheet->setCellValue('D' . $countData, '');
$sheet->setCellValue('E' . $countData, '');
$sheet->setCellValue('F' . $countData, "=sum(F2:F" . $countData - 1 . ")");
$sheet->setCellValue('G' . $countData, "=sum(G2:G" . $countData - 1 . ")");
$sheet->setCellValue('H' . $countData, "=sum(H2:H" . $countData - 1 . ")");
$sheet->setCellValue('I' . $countData, "=sum(I2:I" . $countData - 1 . ")");
$sheet->setCellValue('J' . $countData, '');
$sheet->getStyle('A' . $countData . ':J' . $countData)->applyFromArray($style_row);
$sheet->getRowDimension($countData)->setRowHeight(20);
// Set width kolom
$sheet->getColumnDimension('A')->setWidth(7);
$sheet->getColumnDimension('B')->setWidth(40);
$sheet->getColumnDimension('C')->setWidth(20);
$sheet->getColumnDimension('D')->setWidth(8);
$sheet->getColumnDimension('E')->setWidth(15);
$sheet->getColumnDimension('F')->setWidth(15);
$sheet->getColumnDimension('G')->setWidth(15);
$sheet->getColumnDimension('H')->setWidth(15);
$sheet->getColumnDimension('I')->setWidth(15);
$sheet->getColumnDimension('J')->setWidth(20);


// Set orientasi kertas jadi LANDSCAPE
$sheet->getPageSetup()->setOrientation(\PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_PORTRAIT);

// Set judul file excel nya
$sheet->setTitle("Rekapitulasi");

// Proses file excel
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment; filename="Rekapitulasi Tabungan.xlsx"'); // Set nama file excel nya
header('Cache-Control: max-age=0');

$writer = new Xlsx($spreadsheet);
$writer->save('php://output');
