<?php

require_once "../../../../../asset/mod/autoLoad.php";
require_once "../../../layout/conn.php";
require_once "../../../layout/session.php";

$crud = new crudData;
$limit = 25; // Jumlah data per halaman
$page = isset($_POST['page']) ? (int)$_POST['page'] : 1;
$search = isset($_POST['search']) ? $_POST['search'] : '';

//$tanggal1 = isset($_POST['start_date']) ? $_POST['start_date'] : '';
//$tanggal2 = isset($_POST['end_date']) ? $_POST['end_date'] : '';
//$metode = isset($_POST['metode']) ? $_POST['metode'] : '';
//$penerima = isset($_POST['penerima']) ? $_POST['penerima'] : '';
//$jenjang = isset($_POST['jenjang']) ? $_POST['jenjang'] : '';
//$paralel = isset($_POST['paralel']) ? $_POST['paralel'] : '';


$offset = ($page - 1) * $limit;
$query = "SELECT  * FROM  $tb_transaksi WHERE nama LIKE :search || nis LIKE :search ";
$params = [':search' => "%$search%"];

$query .= "order by tanggal desc, jenjang asc, paralel asc, nama asc LIMIT :limit OFFSET :offset";
$stmt = $pdo->prepare($query);
$stmt->bindValue(':search', "%$search%", PDO::PARAM_STR);
$stmt->bindValue(':limit', $limit, PDO::PARAM_INT);
$stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
$stmt->execute();
$no = 0;
//$datas = $stmt->fetchAll(PDO::FETCH_ASSOC);
$datas = $stmt->fetchAll(PDO::FETCH_OBJ);

$output = '<table  cellpadding="10" class="table table-bordered table-striped table-hover table-sm mb-4 mt-3">';

$output .= "<tr bgcolor:blue>
                <th>No</th>
                <th>Tanggal </th>
                <th>Nama</th>
                <th>NIS</th>
                <th>Kelas</th>
                <th>Kode : Jenis Pembayaran</th>
                <th>Periode</th>
                <th>Jumlah</th>
                <th>Setor</th>
                <th>Metode</th>
                <th>Penerima</th>
                <th>Catatan</th>
    </tr>";

if (count($datas) > 0) {
    foreach ($datas as $data) {
        if ($data->jumlah == "" || $data->jumlah == 0) {
            //$jumlah = number_format(0, 0, ",", ".");
            $jumlah = 0;
        } else {
            $jumlah = $format->ribuan($data->jumlah);
        };
        if ($data->setor == "Ya") {
            $setor = "Disetor";
        } else {
            $setor = "--";
        };
        $nis = $data->nis;
        $tahap = $data->tahap;
        //nama Bayar
        $classNB = new namaBayar();
        $ceknamaBayar = $classNB->ceknamaBayar($tahun, $data->jenis, $data->jenjang);

        //startAt
        $classTr = new transaksi();
        $startAt = $classTr->startAt($tb_siswa, $nis);
        $cekbulan = $classTr->cekPeriode($startAt, $tahap, $tahun1, $tahun2);

        //nama Bayar
        $classNB = new namaBayar();
        $ceknamaBayar = $classNB->ceknamaBayar($tahun, $data->jenis, $data->jenjang);

        $showJenis = $classNB->shownamaBayar($tahun, $data->jenis, $data->jenjang);
        $datajenis = $showJenis->fetch(PDO::FETCH_OBJ);
        $field_tang = 'tang_' . $datajenis->kode;
        $setbulanan = $datajenis->bulanan; //Cek Apakah Bulanan

        if ($setbulanan == "Tidak") {
            $periode = "Tahap " . $tahap;
        } else {
            $periode = $cekbulan;
        };

        $penerima = $classTr->namaPenerimaByID($data->penerima);
        $link = new linkpage;
        $no++;
        $num = $no + $offset;


        $output .= "<tr>
                        <td width='5px'>$num</td>
                            <td align=left>" . $format->dateToIndo($data->tanggal) . "</td>
                            <td align=left>$data->nama</td>
                            <td align=left>$nis</td>
                            <td align=left>$data->jenjang - $data->paralel</td>
                            <td align=left>$data->jenis : $ceknamaBayar</td>
                            <td align=left>$periode</td>
                            <td align=right>" . $jumlah . "</td>
                            <td align=left>$setor</td>
                            <td align=left>$data->metode</td>
                            <td align=left>$penerima</td>
                            <td align=left><i style='font-size:8px'>$data->catatan</i></td>
                    </tr>";
    }
} else {
    $output .= '<tr>
        <td colspan="12">Tidak ada Data</td>
    </tr>';
}
$output .= '</table>';


$queryTotal = "SELECT COUNT(id) FROM $tb_transaksi WHERE nama LIKE :search || nis LIKE :search";
$stmtTotal = $pdo->prepare($queryTotal);
$stmtTotal->bindValue(':search', "%$search%", PDO::PARAM_STR);
$stmtTotal->execute();
$totalRows = $stmtTotal->fetchColumn();
$totalPages = ceil($totalRows / $limit);
$output .= '<div>';
for ($i = 1; $i <= $totalPages; $i++) {
    if ($i == $page) {
        $output .= "<button class='pagination_link btn-xs btn-default px-2 py-1 ml-1' data-page_number='{$i}'>{$i}</button>";
    } else {
        $output .= "<button class='pagination_link btn-xs btn-primary px-2 py-1 ml-1' data-page_number='{$i}'>{$i}</button>";
    };
}
$output .= '</div>';

echo $output;
