<style>
    .close:focus {
        outline: none;
    }

    .top-right {
        top: 20px;
        right: 20px;
    }

    .toast {
        border: 1px solid coral
    }
</style>
<div class="content-wrapper clearfix">

    <?php require('./layout/headerpage.php'); ?>

    <div class="container col-12 mb-4 pb-5">
        <div class="row">
            <div class="col-12">
                <div class="col-12">
                    <div class="card  mx-2">
                        <div class="timeline-header bg-primary py-2 pl-2">
                            <b class="text-light judul"><span class="bi bi-clipboard-check"></span> Rekam Transaksi</b>
                        </div>

                        <!-- /.card-header -->
                        <div class="card-body my-0 mx-1">

                            <?php
                            $sekolah = new sekolah;
                            if ($sekolah->dataSekolah('webaddress') == "") {
                                // $direct = new toast();
                                echo  "  <div class='row mb-3'><b class='text-danger'>Alamat Web belum diseting pada Pengaturan Lembaga. Lakukan Pengaturan Dahulu ..!!</b></div>";
                            };
                            ?>
                            <div class="row mt-2">
                                <label class="col-lg-1 col-sm-12 col-form-label text-primary mt-0 ">View </label>
                                <div class="col-lg-1 col-sm-12">
                                    <select id="limit" class="form-control form-control-sm fontInput small">

                                        <option value="50">50</option>
                                        <option value="100">100</option>
                                        <option value="200">200</option>
                                        <option value="500">500</option>
                                        <option value="1000">1000</option>

                                    </select>
                                </div>

                                <label class="col-lg-1 col-sm-12 col-form-label text-primary mt-0">Cari Siswa </label>
                                <div class="col-lg-3 col-sm-12">
                                    <input type="text" id="search" placeholder="Nama atau NIS" class="form-control form-control-sm fontInput">
                                </div>

                            </div>
                            <table class="table table-condensed table-sm table-striped mb-4 mt-3">
                                <thead>
                                    <tr>
                                        <th width="15">No</th>
                                        <th width="50">Bayar</th>

                                        <?php
                                        $clasSekolah = new sekolah;
                                        $aksesteller = $clasSekolah->dataSekolah('aksesteller');

                                        if ($aksesteller == "ya") {
                                            echo "";
                                        } else {
                                            echo "<th width='50'>Edit</th>";
                                        }; ?>

                                        <th>Nama Siswa</th>
                                        <th>NIS</th>
                                        <th>Kelas</th>
                                        <th>Telpon</th>
                                        <!--
                                        <th>Tanggungan</th>
                                        <th>Terbayar</th>
                                        <th>Kurang</th>
                        -->
                                    </tr>
                                </thead>
                                <tbody id="dataTable"></tbody>
                            </table>
                            <div id="spinner">
                                <img src="../../asset/dokumen/foto/spinner2.gif" width="60" height="60" />
                                <p class="text-success"><i>Sedang memuat Data...</i></p>
                            </div>
                            <div id="recordInfo" class="mb-2"></div>
                            <div id="pagination"></div>

                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>



<script>
    $(document).ready(function() {
        $('#spinner').show();
        const loadData = (page = 1, limit = 50, search = '') => {
            $.ajax({
                url: 'view/transaksi/fetch/fetch_siswa_read.php',
                type: 'GET',
                data: {
                    page,
                    limit,
                    search
                },
                success: function(data) {
                    const {
                        rows,
                        pagination,
                        totalRecords
                    } = JSON.parse(data);
                    $('#dataTable').html(rows);
                    $('#pagination').html(pagination);
                    $('#recordInfo').text(`Record : ${totalRecords} `);
                    $('#spinner').hide();
                }
            });
        };

        $('#limit').change(function() {
            loadData(1, $(this).val(), $('#search').val());
        });

        $('#pagination').on('click', 'a', function(e) {
            e.preventDefault();
            const page = $(this).data('page');
            const limit = $('#limit').val();
            loadData(page, limit, $('#search').val());
        });

        $('#checkAll').click(function() {
            $('input[name="selectRow"]').prop('checked', this.checked);
        });

        $('#deleteSelected').click(function() {
            const ids = $('input[name="selectRow"]:checked').map(function() {
                return $(this).val();
            }).get();
            if (ids.length) {
                $.post('view/transaksi/fetch/fetch_siswa_delete.php', {
                    ids
                }, function(response) {
                    loadData(1, $('#limit').val(), $('#search').val());
                });
            } else {
                alert('Tidak Ada Data yang dipilih');
            }
        });


        $('#search').keyup(function() {
            loadData(1, $('#limit').val(), $(this).val());
        });

        loadData();
    });
</script>