<?php
// Hak Cipta dilindungi Undang-undang. Hak Cipta : Khamdi Rahmani, Reg. Kemenkum HAM No : 000121327. Dilarang merubah isi File tanpa ijin tertulis dari pemegang Hak Cipta.-->

error_reporting(0);
clearstatcache();
include "../../asset/bootstrap/asset/phpqrcode/qrlib.php";
require "../../asset/bootstrap/asset/fpdf/fpdf.php";

$tahun1 =  substr($tahun, 2, 2);
$tahun2 =  substr($tahun, 7, 2);

$view = new lembaga;
$format = new format;
$sekolah = new sekolah;
$time = new time;

//$code = "Pembayaran sejumlah " . $format->ribuan($jmlKuitansi) . " atas nama $data->nama NIS $data->nis INVOICE $id_tr pada " . $format->dateToIndo($timeTr) . " diterima oleh $data->penerima";
$code = $clssekolah->dataSekolah('webaddress') . "/app/validate/?t4h0n=$tahun&i4=" . $id_tr . "&p463=a1a8fd312d5736c4d1e9b578c68e2a00";
//QRCode::png($code, "view/transaksi/qrcodepdf.png", "L", 4, 4);
QRCode::png($code, "../../qrcode/qrcodepdf_" . $id_tr . ".png", "L", 4, 4);

$pdf = new FPDF("P", "cm", "A4");
$pdf->SetMargins(0.8, 0.2, 0.6);
$pdf->AliasNbPages();
$pdf->AddPage();
$pdf->SetFont('Arial', 'B', 11);

$pdf->ln(0.3);
$pdf->Image($view->linkImageFPDF('../../asset/dokumen/foto/', 'logo'), 0.9, 0.4, 0.9, 0.9);
$pdf->Image($view->linkImageFPDF('../../qrcode/', 'qrcodepdf_' . $id_tr), 11, 1.5, 1.6, 1.6);


$pdf->SetFont('Arial', 'B', 11);
$pdf->Cell(1.2, 0.5, '', 0, 0, 'C');
$pdf->Cell(9, 0.5, $sekolah->dataSekolah('sekolah'), 0, 1, 'L');


$pdf->SetFont('Arial', '', 7);
$pdf->Cell(1.2, 0.3, '', 0, 0, 'C');
$pdf->Cell(13, 0.3, $sekolah->dataSekolah('alamat'), 0, 0, 'L');
$pdf->SetFont('Arial', 'B', 9);
$pdf->Cell(9, 0.3, 'BUKTI PEMBAYARAN', 0, 1, 'L');
$pdf->SetFont('Arial', 'B', 8);
$pdf->Cell(9, 0.1, '_______________________________________________________________________________________________________________________', 0, 1, 'L');


$pdf->ln(0.3);

$pdf->SetFont('Arial', '', 9);

$pdf->Cell(2.7, 0.4, $val_pembayar1, 0, 0, 'L');
$pdf->Cell(0.2, 0.4, ':', 0, 0, 'C');
$pdf->Cell(9, 0.4,  strtoupper($format->entityEncode($pembayar1)), 0, 0, 'L');

$pdf->Cell(2.7, 0.4, 'Tanggal Trans', 0, 0, 'L');
$pdf->Cell(0.2, 0.4, ':', 0, 0, 'C');
$pdf->Cell(7, 0.4, $format->dateToIndo($timeTr), 0, 1, 'L');

$pdf->Cell(2.7, 0.4, $val_pembayar2 . ' / ' . $val_pembayar3, 0, 0, 'L');
$pdf->Cell(0.2, 0.4, ':', 0, 0, 'C');
$pdf->Cell(9, 0.4, $pembayar2 . ' / ' . $pembayar3, 0, 0, 'L');

$pdf->Cell(2.7, 0.4, 'Tanggal Cetak', 0, 0, 'L');
$pdf->Cell(0.2, 0.4, ':', 0, 0, 'C');
$pdf->Cell(7, 0.4, $format->dateTimeToIndo($time->getTime()), 0, 1, 'L');

$pdf->Cell(2.7, 0.4, 'Penerima', 0, 0, 'L');
$pdf->Cell(0.2, 0.4, ':', 0, 0, 'C');
$pdf->Cell(9, 0.4, $format->entityEncode($penerima), 0, 0, 'L');

$pdf->Cell(2.7, 0.4, 'No Seri', 0, 0, 'L');
$pdf->Cell(0.2, 0.4, ':', 0, 0, 'C');
$pdf->Cell(7, 0.4, strtoupper($id_tr) . '-' . $codeh, 0, 1, 'L');


$pdf->SetFont('Arial', '', 9);
$pdf->Cell(9, 0.1, '__________________________________________________________________________________________________________', 0, 1, 'L');

$pdf->ln(0.3);


$class = new transaksi();
$crud = new crudData();
$showList = $class->showTransaksiID($tb_transaksi, $id_tr);
$no = 0;
while ($dataTr = $showList->fetch(PDO::FETCH_OBJ)) {
	if ($dataTr->jumlah == "" || $dataTr->jumlah == 0) {
		$jumlah = number_format(0, 0, ",", ".");
	} else {
		$jumlah = number_format($dataTr->jumlah, 0, ",", ".");
	};

	$tahap = $dataTr->tahap;

	//startAt
	$startAt = $class->startAt($tb_siswa, $nis);
	$cekbulan = $class->cekPeriode($startAt, $tahap, $tahun1, $tahun2);

	//nama Bayar
	$classNB = new namaBayar();
	$ceknamaBayar = $classNB->ceknamaBayar($tahun, $dataTr->jenis, $dataTr->jenjang);

	$showJenis = $classNB->shownamaBayar($tahun, $dataTr->jenis, $dataTr->jenjang);
	$datajenis = $showJenis->fetch(PDO::FETCH_OBJ);
	$field_tang = 'tang_' . $datajenis->kode;
	$setbulanan = $datajenis->bulanan; //Cek Apakah Bulanan

	$info_tahap = $sekolah->dataSekolah('info_tahap');

	if ($info_tahap != "ya") {
		$periode = "";
	} elseif ($setbulanan == "Tidak") {
		$periode = "Tahap " . $tahap;
	} else {
		$periode = $cekbulan;
	};
	$no++; // increment untuk menampilkan nomor urut	

	$pdf->SetFont('Arial', '', 9);
	$pdf->Cell(0.5, 0.4, $no, 0, 0, 'L');
	$pdf->Cell(15.7, 0.4, $dataTr->jenis . ' : ' . substr($ceknamaBayar, 0, 40) . ' ' . $periode, 0, 0, 'L');
	$pdf->Cell(2.3, 0.4, $jumlah, 0, 1, 'R');
	//Keterangan Tunak/Bank & No Seri Transaksi
	if (strlen($dataTr->catatan > 2)) {
		$pdf->SetFont('Arial', 'I', 5);
		$pdf->Cell(0.5, 0.4, '', 0, 0, 'L');
		$pdf->Cell(15.7, 0.4, substr($dataTr->catatan, 0, 25), 0, 0, 'L');
		$pdf->Cell(2.3, 0.4, '', 0, 1, 'R');
	} else {
		echo "";
	};
};

$pdf->SetFont('Arial', '', 9);
$pdf->Cell(9, 0.4, '__________________________________________________________________________________________________________', 0, 1, 'L');

$pdf->ln(0.3);
$pdf->SetFont('Arial', 'B', 9);
$pdf->Cell(16, 0.4, 'TOTAL', 0, 0, 'L');
$pdf->Cell(0.2, 0.4, '', 0, 0, 'C');
$pdf->Cell(2.3, 0.4, $format->ribuan($jmlKuitansi), 0, 1, 'R');

$pdf->SetFont('Arial', 'I', 9);

$pdf->Cell(2.3, 0.4, 'Terbilang', 0, 0, 'L');
$pdf->Cell(0.2, 0.4, ':', 0, 0, 'C');
$pdf->Cell(7, 0.4, ucwords($format->terbilang($jmlKuitansi)) . 'Rupiah', 0, 1, 'L');
$pdf->ln(0.1);
$pdf->SetFont('Arial', '', 9);
$pdf->Cell(9, 0.4, '__________________________________________________________________________________________________________', 0, 1, 'L');


$pdf->ln(0.1);
if ($crud->getValue('sekolah', '', 'info_kuitansi') == "ya") {
	$pdf->SetFont('Arial', '', 9);
	$pdf->Cell(16, 0.4, 'Tanggungan', 0, 0, 'L');
	$pdf->Cell(0.2, 0.4, '', 0, 0, 'C');
	$pdf->Cell(2.3, 0.4, $total_tang, 0, 1, 'R');

	$pdf->Cell(16, 0.4, 'Terbayar', 0, 0, 'L');
	$pdf->Cell(0.2, 0.4, '', 0, 0, 'C');
	$pdf->Cell(2.3, 0.4, $terbayarTotal, 0, 1, 'R');


	$pdf->Cell(16, 0.4, 'Kurang', 0, 0, 'L');
	$pdf->Cell(0.2, 0.4, '', 0, 0, 'C');
	$pdf->Cell(2.3, 0.4, $kurangTotal, 0, 1, 'R');
	$pdf->SetFont('Arial', '', 9);
	$pdf->Cell(9, 0.4, '__________________________________________________________________________________________________________', 0, 1, 'L');
} else {
	$pdf->Cell(0.2, 0.3, '', 0, 0, 'C');
};

$time = new time;
$format = new format;
$waktu = $format->dateTimeToIndo($time->getTime());

$pdf->Cell(11.5, 0.6, $crud->getValue('sekolah', '', 'tk'), 0, 0, 'L');
$pdf->SetFont('Arial', 'I', 5);
$pdf->Cell(7, 0.4, strtoupper($data->nama) . "-" . $data->nis . "-" .  $data->jenjang . '.' . $data->paralel, 0, 1, 'R');

$pdf->Cell(11.7, 0.2, '', 0, 0, 'L');
$pdf->Cell(7, 0.2, "Dicetak pada : " . $waktu, 0, 1, 'R');

$pdf->SetFont('Arial', '', 8);

$pdf->Cell(4.2, 0.4, '', 0, 0, 'C');
$pdf->Cell(8.7, 0.4, 'Teler/Penerima', 0, 0, 'L');
$pdf->Cell(2.7, 0.4, 'Penyetor', 0, 1, 'L');

$pdf->ln(1.3);
$pdf->Cell(4.2, 0.4, '', 0, 0, 'C');
$pdf->Cell(8.7, 0.4, '[ ' . $format->entityEncode($penerima) . ' ]', 0, 0, 'L');
$pdf->Cell(2.7, 0.4, '[ ' . strtoupper($format->entityEncode($pembayar1)) . ' ]', 0, 1, 'L');




//Nama file ketika di print
$namaf = "./view/transaksi/print_" . strtoupper($id_tr) . ".pdf";
$pdf->Output($namaf, "F");
