<?php
date_default_timezone_set('Asia/Jakarta');
$tanggal = mktime(date("m"), date("d"), date("Y"));
$tglsekarang = date("d-m-Y", $tanggal);

if (isset($_POST['jenis']) && $_POST['jenis'] != 'Semua') {
    $jenis_lap = $_POST['jenis'];
} else {
    $jenis_lap = "Semua";
};
if (isset($_POST['jenjang'])) {
    $jenjang_lap = $_POST['jenjang'];
    $jenjang_post = $_POST['jenjang'];
    //$aktifjenis = "";
} else {
    $jenjang_lap = "--Pilih--";
    $jenjang_post = "Semua";
    // $aktifjenis = "disabled";
};
if (isset($_POST['paralel']) && $_POST['paralel'] != 'Semua') {
    $paralel_lap = $_POST['paralel'];
} else {
    $paralel_lap = "Semua";
};
if (isset($_POST['status']) && $_POST['status'] != 'Semua') {
    $status_lap = $_POST['status'];
} else {
    $status_lap = "Semua";
};

if (isset($_POST['kategori'])) {
    $kategori = $_POST['kategori'];
} elseif (isset($_GET['i4'])) {
    $kategori = $_GET['i4'];
} else {
    $kategori = "";
};

$dt_jenis = new namaBayar();
$sekolah = new sekolah();

$showJenis = $dt_jenis->shownamaBayar($tahun, $jenis_lap, $jenjang_lap);
$count_nb = $showJenis->rowCount();
$datajenis = $showJenis->fetch(PDO::FETCH_OBJ);
if ($count_nb > 0) {
    $namaBayar = $datajenis->nama;
} else {
    $namaBayar = "Semua";
};

//Query Tanggungan
$classTanggungan = new listTanggungan();
$val_sumtang = $classTanggungan->sumTanggunganByFilterRekap($tb_siswa, $jenjang_post, $paralel_lap, $status_lap, $jenis_lap);

if ($val_sumtang == "" || $val_sumtang  == 0 || isset($_POST['jenjang']) == NULL) {
    $sumtanggungan = number_format(0, 0, ",", ".");
    $v_sumtanggungan = 0;
} else {
    $sumtanggungan = number_format($val_sumtang, 0, ",", ".");
    $v_sumtanggungan = $val_sumtang;
};

//Terbayar & Kurang
if (isset($_POST['jenjang']) == NULL) {
    $terbayar = @(number_format(0, 0, ".", "."));
    $kurang = @(number_format(0, 0, ".", "."));;
} else {
    $classTrans = new transaksi();
    $Terbayar = $classTrans->sumTerbayarRekap($tb_transaksi, $tb_siswa, $jenjang_post, $paralel_lap, $status_lap, $jenis_lap);
    //$Terbayar = 50000;
    $terbayar = @(number_format($Terbayar, 0, ".", "."));
    $kurang = $v_sumtanggungan - $Terbayar;
    $kurang = @(number_format(($kurang), 0, ".", "."));
};


?>

<div class="content-wrapper">

    <?php require('./layout/headerpage.php'); ?>

    <div class="container col-12 mb-4 pb-5">
        <div class="row">
            <div class="col-12">
                <div class="col-12">
                    <div class="card  mx-3">
                        <div class="timeline-header bg-primary  py-2 pl-2">
                            <b class="text-light judul"><span class="bi bi-journal-text"></span> Laporan Per Kategori <?php echo $kategori; ?> </b>
                        </div>

                    </div>
                </div>


                <div class="card-body mx-4">
                    <label>
                        <h6><b class="text-primary">REKAPITULASI</b></h6>
                    </label>
                    <table id="example51" class="table table-bordered table-striped table-hover table-sm mb-4">
                        <thead>
                            <tr>
                                <th>No</th>
                                <th>Nama</th>
                                <th>NIS</th>
                                <th>Kategori</th>
                                <th>Kelas</th>

                                <th>Tanggungan</th>

                            </tr>
                        </thead>
                        <tbody>

                            <?php
                            $classLaporan = new laporan();
                            $crud = new crudData();
                            $showList = $crud->showTable($tb_siswa . " where kategori='$kategori' order by jenjang asc, paralel asc, nama asc");
                            $no = 1;
                            while ($data = $showList->fetch(PDO::FETCH_OBJ)) {

                                $nis = $data->nis;
                                $id = $data->id;
                                $nama = $data->nama;
                                $jenjang = $data->jenjang;
                                $kategori = $data->kategori;
                                $paralel = $data->paralel;
                                $kelas = $jenjang . '-' . $paralel;

                                //Jumlah
                                $dt_jenis = new listTanggungan();
                                $jumlah = $dt_jenis->tanggunganSiswa($tb_siswa, 'id', $id);
                                $total_tang = number_format($jumlah, 0, ".", ".");

                                //Terbayar & Kurang Total
                                $infoTerbayartotal = $classTrans->infoterbayartotal($tb_transaksi, $nis);
                                $terbayarTotal = @(number_format($infoTerbayartotal, 0, ".", "."));
                                $kurangTotal = @(number_format(($jumlah - $infoTerbayartotal), 0, ".", "."));

                                echo "
                                    <tr>
                                        <td width='5px'>$no</td>
                                        <td align=left>$nama</td>
                                        <td align=left>$nis</td>
                                        <td align=left>$kategori</td>
                                        <td align=left>$kelas</td>
                                        <td align='left'>";

                                echo "<table id='' border='2' cellpadding='3' cellspacing='0' class='table table-condensed'>
                                                <tr bgcolor='#CCCCCC'>
                                                    <th width='5'align='center'><b>No</b></th>
                                                    <th width='200'align='center'><b>Kode : Jenis Pembayaran</b></th>
                                                    <th width='70' align='center'><b>Tanggungan</b></th>
                                                    <th width='70' align='center'><b>Terbayar</b></th>
                                                    <th width='70' align='center'><b>Kurang</b></th>
                                                </tr>";
                                //RINCIAN 
                                $dt_jenis = new namaBayar();
                                $showJenis = $dt_jenis->NamaTransaksi('tb_nama_bayar', 'tp', $tahun, $jenjang, 'kode');
                                $count = $showJenis->rowCount();
                                $no_jenis = 0;
                                while ($datajenis = $showJenis->fetch(PDO::FETCH_OBJ)) {
                                    $field_tang = 'tang_' . $datajenis->kode;
                                    $namaBayar =  $datajenis->nama;
                                    $kode =  $datajenis->kode;

                                    if ($data->{$field_tang} == "" || !is_numeric($data->{$field_tang})) {
                                        $val_tang = 0;
                                    } else {
                                        $val_tang = $data->{$field_tang};
                                    }; //Cek jika jumlah tanggungan kosong / bukan angka

                                    $setbulanan = $datajenis->bulanan; //Cek Apakah Bulanan

                                    $rupiah_tang = @(number_format($val_tang, 0, ".", "."));
                                    $jenis = $datajenis->kode;

                                    //Terbayar & Kurang
                                    $classTrans = new transaksi();
                                    $infoTerbayar = $classTrans->infoterbayar($tb_transaksi, $nis, $jenis);
                                    $terbayar = @(number_format($infoTerbayar, 0, ".", "."));
                                    $kurang = @(number_format(($val_tang - $infoTerbayar), 0, ".", "."));

                                    if ($setbulanan == "Ya" || $setbulanan == "ya") {
                                        $bulanan = @(number_format(($val_tang / (12 - ($startAt - 1))), 0, ".", "."));
                                        $disabledQty = "";
                                    } else {
                                        $bulanan = "--";
                                        $disabledQty = "disabled";
                                    };

                                    $no_jenis++;
                                    echo "  <tr>
                                                <td>" . $no_jenis . "</td>
                                                <td>" . $kode . " : " . $namaBayar . "</td>
                                                <td align=right>" . $rupiah_tang . "</td>
                                                <td align=right>" . $terbayar . "</td>
                                                <td align=right>" . $kurang . "</td>
                                            </tr>";
                                };
                                echo "  <tr>
                                            <td colspan='2' align='center'><b>JUMLAH</b></td>
                                            <td align=right><b>" . $total_tang . "</b></td>
                                            <td align=right><b>" . $terbayarTotal . "</b></td>
                                            <td align=right><b>" . $kurangTotal . "</b></td>
                                        </tr>";
                                echo "</table>";
                                echo "</td>
                                    </tr>";
                                $no++;
                            }
                            ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>