<?php

//Hak Cipta dilindungi Undang-undang. Hak Cipta : Khamdi Rahmani, Reg. Kemenkum HAM No : 000121327. Dilarang merubah isi File tanpa ijin tertulis dari pemegang Hak Cipta. 

class aks_grafik extends laporan
{
    public function rekapTransaksiBulanan($tabel, $tanggalakhir, $bulan, $tahun)
    {

        $tanggalx = strtotime($tahun . "-" . $bulan . "-01");
        $tanggaly = strtotime($tahun . "-" . $bulan . "-" . $tanggalakhir);

        $tanggal1 = date('Y-m-d', $tanggalx);
        $tanggal2 = date('Y-m-d', $tanggaly);


        $db = database::getInstance();
        $show = $db->runQuery("SELECT SUM(jumlah) FROM {$tabel}  WHERE tanggal>='$tanggal1' and tanggal<='$tanggal2'");
        $data = $show->fetch();
        $value = $data[0];
        return $value;
    }
    public function rekapTransaksiBulananPrePeriode($tabel, $tanggalakhir, $bulan, $tahun)
    {

        // $tanggal2 = $tahun . "-" . $bulan . "-" . $tanggalakhir;

        $tanggaly = strtotime($tahun . "-" . $bulan . "-" . $tanggalakhir);
        $tanggal2 = date('Y-m-d', $tanggaly);


        $db = database::getInstance();
        $show = $db->runQuery("SELECT SUM(jumlah) FROM {$tabel}  WHERE tanggal<'$tanggal2'");
        $data = $show->fetch();
        $value = $data[0];
        return $value;
    }

    public function rekapTransaksiBulananPaskaPeriode($tabel, $tanggalakhir, $bulan, $tahun)
    {

        $tanggaly = strtotime($tahun . "-" . $bulan . "-" . $tanggalakhir);
        $tanggal2 = date('Y-m-d', $tanggaly);

        $db = database::getInstance();
        $show = $db->runQuery("SELECT SUM(jumlah) FROM {$tabel}  WHERE tanggal>'$tanggal2'");
        $data = $show->fetch();
        $value = $data[0];
        return $value;
    }


    public function realisasiBulan($tb_transaksi, $tahun)
    {
        $tahun1 = substr($tahun, 0, 4);
        $tahun2 = substr($tahun, 5, 4);
        $pre = $this->rekapTransaksiBulananPrePeriode($tb_transaksi, '01', '07', $tahun1);
        $jul = $this->rekapTransaksiBulanan($tb_transaksi, '31', '07', $tahun1);
        $agt = $this->rekapTransaksiBulanan($tb_transaksi, '31', '08', $tahun1);
        $sep = $this->rekapTransaksiBulanan($tb_transaksi, '30', '09', $tahun1);
        $okt = $this->rekapTransaksiBulanan($tb_transaksi, '31', '10', $tahun1);
        $nop = $this->rekapTransaksiBulanan($tb_transaksi, '30', '11', $tahun1);
        $des = $this->rekapTransaksiBulanan($tb_transaksi, '31', '12', $tahun1);
        $jan = $this->rekapTransaksiBulanan($tb_transaksi, '31', '01', $tahun2);
        $feb = $this->rekapTransaksiBulanan($tb_transaksi, '29', '02', $tahun2);
        $mar = $this->rekapTransaksiBulanan($tb_transaksi, '31', '03', $tahun2);
        $apr = $this->rekapTransaksiBulanan($tb_transaksi, '30', '04', $tahun2);
        $mei = $this->rekapTransaksiBulanan($tb_transaksi, '31', '05', $tahun2);
        $jun = $this->rekapTransaksiBulanan($tb_transaksi, '30', '06', $tahun2);
        $paska = $this->rekapTransaksiBulananPaskaPeriode($tb_transaksi, '30', '06', $tahun2);
        $value = "'$pre','$jul', '$agt', '$sep', '$okt', '$nop', '$des', '$jan', '$feb', '$mar', '$apr', '$mei', '$jun','$paska'";
        return $value;
    }

    public function rekapTransaksiBulananperJenjang($tabel, $tanggalakhir, $bulan, $tahun, $jenjang)
    {
        $tanggalx = strtotime($tahun . "-" . $bulan . "-01");
        $tanggaly = strtotime($tahun . "-" . $bulan . "-" . $tanggalakhir);

        $tanggal1 = date('Y-m-d', $tanggalx);
        $tanggal2 = date('Y-m-d', $tanggaly);

        $db = database::getInstance();
        $show = $db->runQuery("SELECT SUM(jumlah) FROM {$tabel}  WHERE tanggal>='$tanggal1' and tanggal<='$tanggal2' and jenjang='$jenjang'");
        $data = $show->fetch();
        $value = $data[0];
        return $value;
    }
    public function rekapTransaksiBulananperJenjangPrePeriode($tabel, $tanggalakhir, $bulan, $tahun, $jenjang)
    {
        $tanggaly = strtotime($tahun . "-" . $bulan . "-" . $tanggalakhir);
        $tanggal2 = date('Y-m-d', $tanggaly);

        $db = database::getInstance();
        $show = $db->runQuery("SELECT SUM(jumlah) FROM {$tabel}  WHERE tanggal<'$tanggal2' and jenjang='$jenjang'");
        $data = $show->fetch();
        $value = $data[0];
        return $value;
    }
    public function rekapTransaksiBulananperJenjangPaskaPeriode($tabel, $tanggalakhir, $bulan, $tahun, $jenjang)
    {
        $tanggaly = strtotime($tahun . "-" . $bulan . "-" . $tanggalakhir);
        $tanggal2 = date('Y-m-d', $tanggaly);

        $db = database::getInstance();
        $show = $db->runQuery("SELECT SUM(jumlah) FROM {$tabel}  WHERE tanggal>'$tanggal2' and jenjang='$jenjang'");
        $data = $show->fetch();
        $value = $data[0];
        return $value;
    }

    public function realisasiBulanperJenjang($tb_transaksi, $tahun, $jenjang)
    {
        $tahun1 = substr($tahun, 0, 4);
        $tahun2 = substr($tahun, 5, 4);

        $sisaBagi = $tahun2 % 4;

        $pre = $this->rekapTransaksiBulananperJenjangPrePeriode($tb_transaksi, '01', '07', $tahun1, $jenjang);
        $jul = $this->rekapTransaksiBulananperJenjang($tb_transaksi, '31', '07', $tahun1, $jenjang);
        $agt = $this->rekapTransaksiBulananperJenjang($tb_transaksi, '31', '08', $tahun1, $jenjang);
        $sep = $this->rekapTransaksiBulananperJenjang($tb_transaksi, '30', '09', $tahun1, $jenjang);
        $okt = $this->rekapTransaksiBulananperJenjang($tb_transaksi, '31', '10', $tahun1, $jenjang);
        $nop = $this->rekapTransaksiBulananperJenjang($tb_transaksi, '30', '11', $tahun1, $jenjang);
        $des = $this->rekapTransaksiBulananperJenjang($tb_transaksi, '31', '12', $tahun1, $jenjang);
        $jan = $this->rekapTransaksiBulananperJenjang($tb_transaksi, '31', '01', $tahun2, $jenjang);

        if ($sisaBagi == 0) {
            $feb = $this->rekapTransaksiBulananperJenjang($tb_transaksi, '29', '02', $tahun2, $jenjang);
        } else {
            $feb = $this->rekapTransaksiBulananperJenjang($tb_transaksi, '28', '02', $tahun2, $jenjang);
        }

        $mar = $this->rekapTransaksiBulananperJenjang($tb_transaksi, '31', '03', $tahun2, $jenjang);
        $apr = $this->rekapTransaksiBulananperJenjang($tb_transaksi, '30', '04', $tahun2, $jenjang);
        $mei = $this->rekapTransaksiBulananperJenjang($tb_transaksi, '31', '05', $tahun2, $jenjang);
        $jun = $this->rekapTransaksiBulananperJenjang($tb_transaksi, '30', '06', $tahun2, $jenjang);
        $paska = $this->rekapTransaksiBulananperJenjangPaskaPeriode($tb_transaksi, '30', '06', $tahun2, $jenjang);
        $value = "'$pre','$jul', '$agt', '$sep', '$okt', '$nop', '$des', '$jan', '$feb', '$mar', '$apr', '$mei', '$jun','$paska'";
        return $value;
    }

    public function chartBulanperJenjang($tb_transaksi, $tahun, $jenjang, $color)
    {
        $realisasi = $this->realisasiBulanperJenjang($tb_transaksi, $tahun, $jenjang);
        echo "{
            type: 'line',
            label: 'Kelas $jenjang',
            borderColor: window.chartColors.{$color},
            borderWidth: 2,
            fill: false,
            data: [$realisasi],
        },";
    }

    public function lineColor($tingkat)
    {
        if ($tingkat == 1) {
            $color = "orange";
        } elseif ($tingkat == 2) {
            $color = "red";
        } elseif ($tingkat == 3) {
            $color = "green";
        } elseif ($tingkat == 4) {
            $color = "yellow";
        } elseif ($tingkat == 5) {
            $color = "blue";
        } elseif ($tingkat == 6) {
            $color = "grey";
        } elseif ($tingkat == 7) {
            $color = "default";
        } else {
            $color = "grey";
        };
        return $color;
    }

    public function rekapTransaksiHarian($tabel, $tanggal)
    {
        $db = database::getInstance();
        $format = new format;
        $show = $db->runQuery("SELECT SUM(jumlah) FROM {$tabel}  WHERE tanggal='$tanggal'");
        $data = $show->fetch();
        $value = $data[0];
        return $value;
    }
    public function rekapTransaksiHarianperJenjang($tabel, $tanggal, $jenjang)
    {
        $db = database::getInstance();
        $format = new format;
        // $tanggal = date('Y-m-d', strtotime($format->dateToEng($tanggal)));
        $show = $db->runQuery("SELECT SUM(jumlah) FROM {$tabel}  WHERE tanggal='$tanggal' and jenjang='$jenjang'");
        $data = $show->fetch();
        $value = $data[0];
        return $value;
    }

    public function realisasiHari($tb_transaksi, $periode)
    {
        $format = new format;
        $tahun = substr($periode, 0, 4);
        $bulan = substr($periode, -2);
        $sisaBagi = $tahun % 4;

        $tlg1 = $this->rekapTransaksiHarian($tb_transaksi, $format->stringTotDate($periode . "-01"));
        $tlg2 = $this->rekapTransaksiHarian($tb_transaksi, $format->stringTotDate($periode . "-02"));
        $tlg3 = $this->rekapTransaksiHarian($tb_transaksi, $format->stringTotDate($periode . "-03"));
        $tlg4 = $this->rekapTransaksiHarian($tb_transaksi, $format->stringTotDate($periode . "-04"));
        $tlg5 = $this->rekapTransaksiHarian($tb_transaksi, $format->stringTotDate($periode . "-05"));
        $tlg6 = $this->rekapTransaksiHarian($tb_transaksi, $format->stringTotDate($periode . "-06"));
        $tlg7 = $this->rekapTransaksiHarian($tb_transaksi, $format->stringTotDate($periode . "-07"));
        $tlg8 = $this->rekapTransaksiHarian($tb_transaksi, $format->stringTotDate($periode . "-08"));
        $tlg9 = $this->rekapTransaksiHarian($tb_transaksi, $format->stringTotDate($periode . "-09"));
        $tlg10 = $this->rekapTransaksiHarian($tb_transaksi, $format->stringTotDate($periode . "-10"));
        $tlg11 = $this->rekapTransaksiHarian($tb_transaksi, $format->stringTotDate($periode . "-11"));
        $tlg12 = $this->rekapTransaksiHarian($tb_transaksi, $format->stringTotDate($periode . "-12"));
        $tlg13 = $this->rekapTransaksiHarian($tb_transaksi, $format->stringTotDate($periode . "-13"));
        $tlg14 = $this->rekapTransaksiHarian($tb_transaksi, $format->stringTotDate($periode . "-14"));
        $tlg15 = $this->rekapTransaksiHarian($tb_transaksi, $format->stringTotDate($periode . "-15"));
        $tlg16 = $this->rekapTransaksiHarian($tb_transaksi, $format->stringTotDate($periode . "-16"));
        $tlg17 = $this->rekapTransaksiHarian($tb_transaksi, $format->stringTotDate($periode . "-17"));
        $tlg18 = $this->rekapTransaksiHarian($tb_transaksi, $format->stringTotDate($periode . "-18"));
        $tlg19 = $this->rekapTransaksiHarian($tb_transaksi, $format->stringTotDate($periode . "-19"));
        $tlg20 = $this->rekapTransaksiHarian($tb_transaksi, $format->stringTotDate($periode . "-20"));
        $tlg21 = $this->rekapTransaksiHarian($tb_transaksi, $format->stringTotDate($periode . "-21"));
        $tlg22 = $this->rekapTransaksiHarian($tb_transaksi, $format->stringTotDate($periode . "-22"));
        $tlg23 = $this->rekapTransaksiHarian($tb_transaksi, $format->stringTotDate($periode . "-23"));
        $tlg24 = $this->rekapTransaksiHarian($tb_transaksi, $format->stringTotDate($periode . "-24"));
        $tlg25 = $this->rekapTransaksiHarian($tb_transaksi, $format->stringTotDate($periode . "-25"));
        $tlg26 = $this->rekapTransaksiHarian($tb_transaksi, $format->stringTotDate($periode . "-26"));
        $tlg27 = $this->rekapTransaksiHarian($tb_transaksi, $format->stringTotDate($periode . "-27"));
        $tlg28 = $this->rekapTransaksiHarian($tb_transaksi, $format->stringTotDate($periode . "-28"));

        //$tlg29 = $this->rekapTransaksiHarian($tb_transaksi, $periode . "-29");
        //$tlg30 = $this->rekapTransaksiHarian($tb_transaksi, $periode . "-30");
        //$tlg31 = $this->rekapTransaksiHarian($tb_transaksi, $periode . "-31");


        if ($bulan == "02" && $sisaBagi > 0) {
            $tlg29 = $this->rekapTransaksiHarian($tb_transaksi, $format->stringTotDate($periode . "-29"));
            $tlg30 = 0;
            $tlg31 = 0;
        } elseif ($bulan == "02" && $sisaBagi == 0) {
            $tlg29 = 0;
            $tlg30 = 0;
            $tlg31 = 0;
        } elseif ($bulan == "01" || $bulan == "03" || $bulan == "05" || $bulan == "07" || $bulan == "08" || $bulan == "10" || $bulan == "12") {
            $tlg29 = $this->rekapTransaksiHarian($tb_transaksi, $format->stringTotDate($periode . "-29"));
            $tlg30 = $this->rekapTransaksiHarian($tb_transaksi, $format->stringTotDate($periode . "-30"));
            $tlg31 = $this->rekapTransaksiHarian($tb_transaksi, $format->stringTotDate($periode . "-31"));
        } else {
            $tlg29 = $this->rekapTransaksiHarian($tb_transaksi, $format->stringTotDate($periode . "-29"));
            $tlg30 = $this->rekapTransaksiHarian($tb_transaksi, $format->stringTotDate($periode . "-30"));
            $tlg31 = 0;
        }


        $value = "'$tlg1','$tlg2','$tlg3','$tlg4','$tlg5','$tlg6','$tlg7','$tlg8','$tlg9','$tlg10','$tlg11','$tlg12','$tlg13','$tlg14','$tlg15','$tlg16','$tlg17','$tlg18','$tlg19','$tlg20','$tlg21','$tlg22','$tlg23','$tlg24','$tlg25','$tlg26','$tlg27','$tlg28','$tlg29','$tlg30','$tlg31'";
        return $value;
    }

    public function realisasiHariperJenjang($tb_transaksi, $periode, $jenjang)
    {
        $format = new format;
        $tahun = substr($periode, 0, 4);
        $bulan = substr($periode, -2);
        $sisaBagi = $tahun % 4;

        $tlg1 = $this->rekapTransaksiHarianperJenjang($tb_transaksi, $format->stringTotDate($periode . "-01"), $jenjang);
        $tlg2 = $this->rekapTransaksiHarianperJenjang($tb_transaksi, $format->stringTotDate($periode . "-02"), $jenjang);
        $tlg3 = $this->rekapTransaksiHarianperJenjang($tb_transaksi, $format->stringTotDate($periode . "-03"), $jenjang);
        $tlg4 = $this->rekapTransaksiHarianperJenjang($tb_transaksi, $format->stringTotDate($periode . "-04"), $jenjang);
        $tlg5 = $this->rekapTransaksiHarianperJenjang($tb_transaksi, $format->stringTotDate($periode . "-05"), $jenjang);
        $tlg6 = $this->rekapTransaksiHarianperJenjang($tb_transaksi, $format->stringTotDate($periode . "-06"), $jenjang);
        $tlg7 = $this->rekapTransaksiHarianperJenjang($tb_transaksi, $format->stringTotDate($periode . "-07"), $jenjang);
        $tlg8 = $this->rekapTransaksiHarianperJenjang($tb_transaksi, $format->stringTotDate($periode . "-08"), $jenjang);
        $tlg9 = $this->rekapTransaksiHarianperJenjang($tb_transaksi, $format->stringTotDate($periode . "-09"), $jenjang);
        $tlg10 = $this->rekapTransaksiHarianperJenjang($tb_transaksi, $format->stringTotDate($periode . "-10"), $jenjang);
        $tlg11 = $this->rekapTransaksiHarianperJenjang($tb_transaksi, $format->stringTotDate($periode . "-11"), $jenjang);
        $tlg12 = $this->rekapTransaksiHarianperJenjang($tb_transaksi, $format->stringTotDate($periode . "-12"), $jenjang);
        $tlg13 = $this->rekapTransaksiHarianperJenjang($tb_transaksi, $format->stringTotDate($periode . "-13"), $jenjang);
        $tlg14 = $this->rekapTransaksiHarianperJenjang($tb_transaksi, $format->stringTotDate($periode . "-14"), $jenjang);
        $tlg15 = $this->rekapTransaksiHarianperJenjang($tb_transaksi, $format->stringTotDate($periode . "-15"), $jenjang);
        $tlg16 = $this->rekapTransaksiHarianperJenjang($tb_transaksi, $format->stringTotDate($periode . "-16"), $jenjang);
        $tlg17 = $this->rekapTransaksiHarianperJenjang($tb_transaksi, $format->stringTotDate($periode . "-17"), $jenjang);
        $tlg18 = $this->rekapTransaksiHarianperJenjang($tb_transaksi, $format->stringTotDate($periode . "-18"), $jenjang);
        $tlg19 = $this->rekapTransaksiHarianperJenjang($tb_transaksi, $format->stringTotDate($periode . "-19"), $jenjang);
        $tlg20 = $this->rekapTransaksiHarianperJenjang($tb_transaksi, $format->stringTotDate($periode . "-20"), $jenjang);
        $tlg21 = $this->rekapTransaksiHarianperJenjang($tb_transaksi, $format->stringTotDate($periode . "-21"), $jenjang);
        $tlg22 = $this->rekapTransaksiHarianperJenjang($tb_transaksi, $format->stringTotDate($periode . "-22"), $jenjang);
        $tlg23 = $this->rekapTransaksiHarianperJenjang($tb_transaksi, $format->stringTotDate($periode . "-23"), $jenjang);
        $tlg24 = $this->rekapTransaksiHarianperJenjang($tb_transaksi, $format->stringTotDate($periode . "-24"), $jenjang);
        $tlg25 = $this->rekapTransaksiHarianperJenjang($tb_transaksi, $format->stringTotDate($periode . "-25"), $jenjang);
        $tlg26 = $this->rekapTransaksiHarianperJenjang($tb_transaksi, $format->stringTotDate($periode . "-26"), $jenjang);
        $tlg27 = $this->rekapTransaksiHarianperJenjang($tb_transaksi, $format->stringTotDate($periode . "-27"), $jenjang);
        $tlg28 = $this->rekapTransaksiHarianperJenjang($tb_transaksi, $format->stringTotDate($periode . "-28"), $jenjang);

        if ($bulan == "02" && $sisaBagi > 0) {
            $tlg29 = $this->rekapTransaksiHarianperJenjang($tb_transaksi, $format->stringTotDate($periode . "-29"), $jenjang);
            $tlg30 = 0;
            $tlg31 = 0;
        } elseif ($bulan == "02" && $sisaBagi == 0) {
            $tlg29 = 0;
            $tlg30 = 0;
            $tlg31 = 0;
        } elseif ($bulan == "01" || $bulan == "03" || $bulan == "05" || $bulan == "07" || $bulan == "08" || $bulan == "10" || $bulan == "12") {
            $tlg29 = $this->rekapTransaksiHarianperJenjang($tb_transaksi, $format->stringTotDate($periode . "-29"), $jenjang);
            $tlg30 = $this->rekapTransaksiHarianperJenjang($tb_transaksi, $format->stringTotDate($periode . "-30"), $jenjang);
            $tlg31 = $this->rekapTransaksiHarianperJenjang($tb_transaksi, $format->stringTotDate($periode . "-31"), $jenjang);
        } else {
            $tlg29 = $this->rekapTransaksiHarianperJenjang($tb_transaksi, $format->stringTotDate($periode . "-29"), $jenjang);
            $tlg30 = $this->rekapTransaksiHarianperJenjang($tb_transaksi, $format->stringTotDate($periode . "-30"), $jenjang);
            $tlg31 = 0;
        }


        $value = "'$tlg1','$tlg2','$tlg3','$tlg4','$tlg5','$tlg6','$tlg7','$tlg8','$tlg9','$tlg10','$tlg11','$tlg12','$tlg13','$tlg14','$tlg15','$tlg16','$tlg17','$tlg18','$tlg19','$tlg20','$tlg21','$tlg22','$tlg23','$tlg24','$tlg25','$tlg26','$tlg27','$tlg28','$tlg29','$tlg30','$tlg31'";
        return $value;
    }

    public function chartHariperJenjang($tb_transaksi, $periode, $jenjang, $color)
    {
        $realisasi = $this->realisasiHariperJenjang($tb_transaksi, $periode, $jenjang);
        echo "{
            type: 'line',
            label: 'Kelas $jenjang',
            borderColor: window.chartColors.{$color},
            borderWidth: 2,
            fill: false,
            data: [$realisasi],
        },";
    }
    public function progresBar($persen)
    {
        $persen = (int)$persen;
        if ($persen < 10) {
            $color = "danger";
            $bi = "bi bi-shield-exclamation text-danger";
        } elseif ($persen >= 10 and $persen < 85) {
            $color = "warning";
            $bi = "bi bi-shield-check text-danger";
        } elseif ($persen >= 85) {
            $color = "success";
            $bi = "bi bi-stars text-default";
        } else {
            $color = "default";
            $bi = "bi bi-stars text-danger";
        };


        $pr = "<div class='col-md-12'>
                    <div class='progress progress-md active'>
                        <div class='progress-bar bg-$color progress-bar-striped' role='progressbar'
                            aria-valuenow='$persen' aria-valuemin='0' aria-valuemax='100' style='width: $persen%'>
                            <span class='col-3 $bi'>  " . number_format($persen, 2) . "</span>
                        </div>
                    </div>
                    
                </div>            
               ";

        return $pr;
    }
    public function progresBarSiswa($persen)
    {
        $persen = (int)$persen;
        if ($persen < 50) {
            $color = "danger";
            $bi = "bi bi-shield-exclamation text-light";
        } elseif ($persen >= 50 and $persen < 100) {
            $color = "warning";
            $bi = "bi bi-shield-check text-danger";
        } elseif ($persen >= 100) {
            $color = "success";
            $bi = "bi bi-stars text-default";
        } else {
            $color = "default";
            $bi = "bi bi-stars text-danger";
        };


        $pr = "<div class='col-md-12 mb-2'>
        <div class='progress progress-md active'><div class='progress-bar bg-$color progress-bar-striped' role='progressbar'
                            aria-valuenow='$persen' aria-valuemin='0' aria-valuemax='100' style='width: $persen%'>
                            <span class='col-3 $bi'>  " . number_format($persen, 2) . " %</span>
                        </div></div></div>
               ";

        return $pr;
    }
}
