<?php

error_reporting(1);

$time = new time();
$format = new format();
$view = new lembaga;
$sekolah = new sekolah();


$tahun_tabel = substr($tahun, 2, 2) . substr($tahun, 7, 2);

$tb_siswa = "tb_siswa" . $tahun_tabel;
$tb_transaksi = "db_transaksi" . $tahun_tabel;
$tb_detailakun = "detail_akun" . $tahun_tabel;

$clsCrud = new crudData();
$showData = $crud->editData($tb_siswa, 'nis', $nis);
$data = $showData->fetch(PDO::FETCH_OBJ);


$count = $clsCrud->countData($tb_siswa, " where nis='$nis'");
if ($count > 0) {
    $kelas = $clsCrud->getValue($tb_siswa, " where nis='$nis'", 'jenjang') . "-" . $clsCrud->getValue($tb_siswa, " where nis='$nis'", 'paralel');
} else {
    $kelas = "--";
};

$nama = $data->nama;
$kelamin = $data->kelamin;
$status = $data->status;
$kategori = $data->kategori;
$hp = $data->hp;
$email = $data->email;
$jenjang = $data->jenjang;
$paralel = $data->paralel;
$catatan = $data->catatan;

include "../../asset/bootstrap/asset/phpqrcode/qrlib.php";
require "../../asset/bootstrap/asset/fpdf/fpdf.php";
require "../../asset/mod/autoLoad.php";


$code = $sekolah->dataSekolah('webaddress') . "/app/validate/?t4h0n=$tahun&i4=" . $id . "&p463=fbcbf33971f1adfb7346d1d63c82fb91";
QRCode::png($code, "../../qrcode/qrcodeTab_" . $id . ".png", "L", 4, 4);

$pdf = new FPDF("P", "cm", array(25, 13));
$pdf->SetMargins(0.3, 0.6, 0.2);
$pdf->AliasNbPages();
$pdf->AddPage();
$pdf->SetFont('Arial', 'B', 11);


$pdf->ln(0.3);

$pdf->Image($view->linkImageFPDF('../../asset/dokumen/foto/', 'pembayaran'), 0, 0, 13, 7.5);
$pdf->Image($view->linkImageFPDF('../../asset/dokumen/foto/', 'logo'), 1.9, 0.8, 0.9, 0.9);
$pdf->Image($view->linkImageFPDF('../../qrcode/', 'qrcodeTab_' . $id), 10, 3.5, 2.5, 2.5);


$pdf->SetFont('Arial', 'B', 8);
$pdf->Cell(2.8, 0.5, '', 0, 0, 'C');
$pdf->Cell(9, 0.5, $sekolah->dataSekolah('sekolah'), 0, 1, 'L');


$pdf->SetFont('Arial', 'B', 7);
$pdf->Cell(2.8, 0.3, '', 0, 0, 'C');
$pdf->Cell(9, 0.3, $sekolah->dataSekolah('alamat'), 0, 1, 'L');

$pdf->SetFont('Arial', 'B', 8);

$pdf->ln(1);

$pdf->SetFont('Arial', 'B', 12);
$pdf->Cell(1.5, 0.3, '', 0, 0, 'C');
$pdf->SetTextColor(255, 0, 0);
$pdf->Cell(3, 0.4, 'KARTU PEMBAYARAN DIGITAL', 0, 0, 'L');
$pdf->Cell(0.5, 0.4, '', 0, 1, 'C');
$pdf->SetTextColor(0, 0, 0);


$pdf->SetFont('Arial', 'B', 10);
$pdf->Cell(1.5, 0.5, '', 0, 0, 'C');
$pdf->Cell(3, 0.5, 'TA. ' . $tahun, 0, 0, 'L');
$pdf->Cell(0.5, 0.5, '', 0, 1, 'C');
$pdf->SetFont('Arial', '', 7);

$pdf->ln(0.3);
$pdf->Cell(1.5, 0.4, '', 0, 0, 'C');
$pdf->Cell(2, 0.4, 'Nama', 0, 0, 'L');
$pdf->Cell(0.2, 0.4, ':', 0, 0, 'C');
$pdf->Cell(7, 0.4, $nama, 0, 1, 'L');

$pdf->Cell(1.5, 0.4, '', 0, 0, 'C');
$pdf->Cell(2, 0.4, 'NIS', 0, 0, 'L');
$pdf->Cell(0.2, 0.4, ':', 0, 0, 'C');
$pdf->Cell(7, 0.4, $nis, 0, 1, 'L');

$pdf->Cell(1.5, 0.4, '', 0, 0, 'C');
$pdf->Cell(2, 0.4, 'Kelas', 0, 0, 'L');
$pdf->Cell(0.2, 0.4, ':', 0, 0, 'C');
$pdf->Cell(7, 0.4,  $kelas, 0, 1, 'L');

$pdf->Cell(1.5, 0.4, '', 0, 0, 'C');
$pdf->Cell(2, 0.4, 'kategori', 0, 0, 'L');
$pdf->Cell(0.2, 0.4, ':', 0, 0, 'C');
$pdf->Cell(7, 0.4,  $kategori, 0, 1, 'L');

$pdf->Cell(1.5, 0.4, '', 0, 0, 'C');
$pdf->Cell(2, 0.4, 'No Telp / WA', 0, 0, 'L');
$pdf->Cell(0.2, 0.4, ':', 0, 0, 'C');
$pdf->Cell(7, 0.4,  $hp, 0, 1, 'L');

$pdf->Cell(1.5, 0.4, '', 0, 0, 'C');
$pdf->Cell(2, 0.4, 'Email', 0, 0, 'L');
$pdf->Cell(0.2, 0.4, ':', 0, 0, 'C');
$pdf->Cell(7, 0.4,  $email, 0, 1, 'L');

$pdf->Cell(1.5, 0.4, '', 0, 0, 'C');
$pdf->Cell(2, 0.4, 'Catatan', 0, 0, 'L');
$pdf->Cell(0.2, 0.4, ':', 0, 0, 'C');
$pdf->Cell(7, 0.4,  $catatan, 0, 1, 'L');

$pdf->ln(0.2);

$pdf->SetFont('Arial', 'I', 5);
$pdf->Cell(9.5, 0.5, '', 0, 0, 'C');
$pdf->Cell(1, 0.5, 'Printed at', 0, 0, 'L');
$pdf->Cell(7, 0.5,  $format->dateTimeToIndo($time->getTime()), 0, 1, 'L');

$pdf->ln(0.5);
$pdf->SetFont('Courier', 'B', 11);
$pdf->SetTextColor(250, 10, 20);

if (strlen($sekolah->dataSekolah('notice')) < 3) {
    $pdf->Cell(1, 0.5, 'INFORMASI : ', 0, 1, 'L');
    $pdf->SetTextColor(0, 0, 0);
    $pdf->SetFont('Courier', 'BI', 8);
    $pdf->SetFillColor(255, 255, 255);
    $pdf->MultiCell(12.4, 0.4, '-- Tidak Ada Informasi --', 0, 1, 'L');
} else {
    $pdf->Cell(1, 0.5, 'INFORMASI : ', 0, 1, 'L');
    $pdf->SetTextColor(0, 0, 0);
    $pdf->SetFont('Courier', 'BI', 8);
    $pdf->SetFillColor(255, 255, 255);
    $pdf->MultiCell(12.4, 0.4, $sekolah->dataSekolah('notice'), 0, 1, 'L');
}

$pdf->SetTextColor(0, 0, 0);
$pdf->ln(0.5);
$pdf->SetFont('Courier', 'B', 10);
$pdf->Cell(2, 0.6, 'REKAP PEMBAYARAN', 0, 1, 'l');

$pdf->SetFont('Courier', '', 9);
$pdf->SetFillColor(100, 0, 0);

$pdf->Cell(6, 0.5, 'Jenis Pembayaran', 1, 0, 'C');
$pdf->Cell(2.2, 0.5, 'Tanggungan', 1, 0, 'C');
$pdf->Cell(2.2, 0.5, 'Terbayar', 1, 0, 'C');
$pdf->Cell(2, 0.5, 'Kurang', 1, 1, 'C');

$pdf->SetFillColor(255, 255, 255);

$pdf->SetFont('Courier', '', 6.5);

$namaBayar = new namaBayar();
$showJenis = $namaBayar->NamaTransaksi('tb_nama_bayar', 'tp', $tahun, $jenjang, 'kode');
$count = $showJenis->rowCount();
while ($datajenis = $showJenis->fetch(PDO::FETCH_OBJ)) {
    $field_tang = 'tang_' . $datajenis->kode;

    if ($data->{$field_tang} == "" || !is_numeric($data->{$field_tang})) {
        $val_tang = 0;
    } else {
        $val_tang = $data->{$field_tang};
    }; //Cek jika jumlah tanggungan kosong / bukan angka

    $setbulanan = $datajenis->bulanan; //Cek Apakah Bulanan

    // $rupiah_tang = @(number_format($val_tang, 0, ".", "."));
    $jenis = $datajenis->kode;

    //Terbayar & Kurang
    $classTrans = new transaksi();
    $infoTerbayar = $classTrans->infoterbayar($tb_transaksi, $data->nis, $jenis);
    //$terbayar = @(number_format($infoTerbayar, 0, ".", "."));
    $kurang = ($val_tang - $infoTerbayar);


    $pdf->Cell(6, 0.4, substr($datajenis->kode . " : " . $datajenis->nama, 0, 42), 0, 0, 'L');
    $pdf->Cell(2.2, 0.4, $format->ribuan($val_tang), 0, 0, 'R');
    $pdf->Cell(2.2, 0.4, $format->ribuan($infoTerbayar), 0, 0, 'R');
    $pdf->Cell(2, 0.4, $format->ribuan($kurang), 0, 1, 'R');
};

//Jumlah
$dt_jenis = new listTanggungan();
$jumlah = $dt_jenis->tanggunganSiswa($tb_siswa, 'id', $id);
$infoTerbayartotal = $classTrans->infoterbayartotal($tb_transaksi, $data->nis);

$pdf->SetFont('Courier', 'B', 8);
$pdf->Cell(6, 0.5, 'JUMLAH ', 0, 0, 'C');
$pdf->Cell(2.2, 0.4, $format->ribuan($jumlah), 0, 0, 'R');
$pdf->Cell(2.2, 0.4, $format->ribuan($infoTerbayartotal), 0, 0, 'R');
$pdf->Cell(2, 0.4, $format->ribuan($jumlah - $infoTerbayartotal), 0, 1, 'R');

$pdf->ln(0.5);
$pdf->SetFont('Courier', 'B', 10);
$pdf->Cell(2, 0.6, 'RINCIAN PEMBAYARAN', 0, 1, 'l');

$pdf->SetFont('Courier', '', 9);
$pdf->SetFillColor(100, 0, 0);

$pdf->Cell(1.8, 0.5, 'Tanggal', 1, 0, 'C');
$pdf->Cell(6, 0.5, 'Jenis Pembayaran', 1, 0, 'C');
$pdf->Cell(2.5, 0.5, 'Periode', 1, 0, 'C');
$pdf->Cell(2.2, 0.5, 'Jumlah', 1, 1, 'C');

$pdf->SetFont('Courier', '', 6.5);

$class = new transaksi();
$showList = $class->showTransaksiSiswa($tb_transaksi, $data->nis);
$no = 0;
while ($dataTr = $showList->fetch(PDO::FETCH_OBJ)) {
    if ($dataTr->jumlah == "" || $dataTr->jumlah == 0) {
        $jumlah = number_format(0, 0, ",", ".");
    } else {
        $jumlah = number_format($dataTr->jumlah, 0, ",", ".");
    };

    $tahap = $dataTr->tahap;

    //startAt
    $startAt = $class->startAt($tb_siswa, $data->nis);
    $cekbulan = $class->cekPeriode($startAt, $tahap, $tahun1, $tahun2);

    //nama Bayar
    $classNB = new namaBayar();
    $ceknamaBayar = $classNB->ceknamaBayar($tahun, $dataTr->jenis, $dataTr->jenjang);

    $showJenis = $classNB->shownamaBayar($tahun, $dataTr->jenis, $dataTr->jenjang);
    $datajenis = $showJenis->fetch(PDO::FETCH_OBJ);
    $field_tang = 'tang_' . $datajenis->kode;
    $setbulanan = $datajenis->bulanan; //Cek Apakah Bulanan

    if ($setbulanan == "Tidak") {
        $periode = "Tahap " . $tahap;
    } else {
        $periode = $cekbulan;
    };
    $no++;

    //$penerima = $crud->getValue('user', "where id='$dataTr->penerima'", 'nama');
    $penerima = $class->namaPenerimaByID($dataTr->penerima);

    $pdf->Cell(1.8, 0.4, $format->dateToIndo($dataTr->tanggal), 0, 0, 'C');
    $pdf->Cell(6, 0.4, substr($dataTr->jenis . " : " . $ceknamaBayar, 0, 42), 0, 0, 'L');
    $pdf->Cell(2.5, 0.4, substr($periode, 0, 20), 0, 0, 'L');
    $pdf->Cell(2.2, 0.4, $jumlah, 0, 1, 'R');
}



$pdf->SetFillColor(255, 255, 255);
//$pdf->MultiCell(10.5, 0.5, '---- ' . $format->terbilang($saldoAkhir) . ' rupiah ----', 0, 1, 'R');
//$pdf->Cell(2.2, 0.5, '', 0, 1, 'L');

$pdf->SetFont('Courier', 'I', 7);

//$pdf->MultiCell(12.5, 0.5, '---- ' . $format->terbilang($saldoAkhir) . ' rupiah ----', 0, 1, 'R');

//Nama file ketika di print
$namaf = "view/siswa/Ebook-Pembayaran_" . $id . ".pdf";
$pdf->Output($namaf, "F");
