<div class="content-wrapper">

    <?php require('./layout/headerpage.php'); ?>

    <div class="container col-12 mb-4 pb-5">
        <div class="row">
            <div class="col-12">
                <div class="col-12">
                    <div class="card  mx-3">
                        <div class="timeline-header bg-primary py-2 pl-2">
                            <b class="text-light judul"><span class="bi bi-printer"></span> Cetak Ulang Kuitansi</b>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body my-4 mx-4">

                            <div class="row">
                                <label class="col-lg-1 col-sm-12 col-form-label text-primary mt-0 ">View </label>
                                <div class="col-lg-1 col-sm-12">
                                    <select id="limit" class="form-control form-control-sm fontInput small">
                                        <option value="10">10</option>
                                        <option value="50">50</option>
                                        <option value="100">100</option>
                                        <option value="200">200</option>
                                        <option value="500">500</option>
                                        <option value="1000">1000</option>

                                    </select>
                                </div>

                                <label class="col-lg-1 col-sm-12 col-form-label text-primary mt-0">Cari Transaksi </label>
                                <div class="col-lg-5 col-sm-12 mb-3">
                                    <input type="text" id="search" placeholder="Nama | NIS | ID Transaksi | Tanggal (yyyy-mm-dd)" class="form-control form-control-sm fontInput">
                                </div>

                            </div>
                            <div class="row">
                                <p><b class="text-success"><i>Lakukan Pencarian Data untuk Menampilkan Kuitansi yang akan dicetak Ulang</i></b></p>
                            </div>
                            <table class="table table-condensed table-striped table-hover table-sm mb-4 mt-3">
                                <thead>
                                    <tr>
                                        <th>No</th>
                                        <th>Cetak</th>
                                        <th>Tanggal</th>
                                        <th>Nama</th>
                                        <th>NIS</th>
                                        <th>Kelas</th>
                                        <th>ID Transaksi</th>
                                        <th>Record</th>
                                        <th>Jumlah</th>
                                        <th>Penerima</th>
                                    </tr>
                                </thead>
                                <tbody id="dataTable"></tbody>

                            </table>
                            <div id="spinner">
                                <img src="../../asset/dokumen/foto/spinner2.gif" width="60" height="60" />
                                <p class="text-success"><i>Sedang memuat Data...</i></p>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>

<script>
    $(document).ready(function() {
        $('#spinner').show();
        const loadData = (page = 1, limit = 10, search = '') => {
            $.ajax({
                url: 'view/transaksi/fetch/fetch_kuitansi_read.php',
                type: 'GET',
                data: {
                    page,
                    limit,
                    search
                },
                success: function(data) {
                    const {
                        rows,
                        pagination,
                        totalRecords
                    } = JSON.parse(data);
                    $('#dataTable').html(rows);
                    $('#pagination').html(pagination);
                    $('#recordInfo').text(`Record : ${totalRecords} `);

                    $('#spinner').hide(); // Sembunyikan spinner setelah data di-load
                    //let rows = '';

                },
                error: function() {
                    $('#spinner').hide();
                    alert('Gagal mengambil data');
                }
            });
        };

        $('#limit').change(function() {
            loadData(1, $(this).val(), $('#search').val());
        });

        $('#pagination').on('click', 'a', function(e) {
            e.preventDefault();
            const page = $(this).data('page');
            const limit = $('#limit').val();
            loadData(page, limit, $('#search').val());
        });

        $('#checkAll').click(function() {
            $('input[name="selectRow"]').prop('checked', this.checked);
        });

        $('#deleteSelected').click(function() {
            const ids = $('input[name="selectRow"]:checked').map(function() {
                return $(this).val();
            }).get();
            if (ids.length) {
                $.post('view/seting/siswa/fetch/fetch_siswa_delete.php', {
                    ids
                }, function(response) {
                    loadData(1, $('#limit').val(), $('#search').val());
                });
            } else {
                alert('Tidak Ada Data yang dipilih');
            }
        });



        $('#downloadPDF').click(function() {
            window.location.href = 'export.php?type=pdf&search=' + $('#search').val();
        });

        $('#search').keyup(function() {
            loadData(1, $('#limit').val(), $(this).val());
        });

        loadData();
    });
</script>