<?php

require_once "../../../../../asset/mod/autoLoad.php";
require_once "../../../layout/conn.php";
require_once "../../../layout/session.php";


$crud = new crudData;
$link = new linkpage;

$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$limit = isset($_GET['limit']) ? (int)$_GET['limit'] : 5;
$search = isset($_GET['search']) ? $_GET['search'] : '';
$offset = ($page - 1) * $limit;


$query = "SELECT * FROM $tb_siswa WHERE nama LIKE :search || nis LIKE :search order by jenjang asc, paralel asc, nama asc LIMIT :limit OFFSET :offset";
$stmt = $pdo->prepare($query);
$stmt->bindValue(':search', "%$search%", PDO::PARAM_STR);
$stmt->bindValue(':limit', $limit, PDO::PARAM_INT);
$stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
$stmt->execute();

$datas = $stmt->fetchAll(PDO::FETCH_OBJ);

$total = $pdo->prepare("SELECT COUNT(*) FROM $tb_siswa WHERE nama LIKE :search OR nis LIKE :search");
$total->bindValue(':search', "%$search%", PDO::PARAM_STR);
$total->execute();
$totalRows = $total->fetchColumn();
$totalPages = ceil($totalRows / $limit);

$rows = '';
foreach ($datas as $data) {
    $id_siswa = $data->id;
    $hp_siswa = $data->hp;
    if ($id_siswa == "") {
        $edit = "No ID";
    } else {
        $edit = "<a " . $link->pageID($id_siswa, 'seting/siswa/siswa_edit') . " class='badge badge-secondary  px-1 py-1 d-inline' > <i class='bi bi-pencil-square'></i> EDIT</a>";
    };

    //Query Tanggungan
    //$classTanggungan = new listTanggungan();
    //$val_tang = $classTanggungan->tanggunganByKode($tb_siswa, 'id', $id_siswa, 'Semua');
    //if ($val_tang == "" || $val_tang  == 0) {
    //    $tanggungan = number_format(0, 0, ",", ".");
    //    $v_tanggungan = 0;
    //} else {
    //    $tanggungan = number_format($val_tang, 0, ",", ".");
    //    $v_tanggungan = $val_tang;
    //};
    ////Terbayar & Kurang
    //$classTrans = new transaksi();
    //$Terbayar = $classTrans->infoterbayarIf($tb_transaksi, $data->nis, 'Semua');
    //$terbayar = @(number_format($Terbayar, 0, ".", "."));
    //$kurang = $v_tanggungan - $Terbayar;
    //$kurang = @(number_format(($kurang), 0, ".", "."));


    $no++;
    $num = $no + $offset;

    $rows .= "<tr>";
    $rows .= "<td width='20px' align='center'>$num</td>";
    $rows .= " <td width='50px' align='center'><a " . $link->pageID($id_siswa, 'transaksi/transaksi_create') . " class='badge badge-success  px-1 py-1 d-inline'> <i class='bi bi-credit-card-2-back'></i>  BAYAR</a></td>";

    $clasSekolah = new sekolah;
    $aksesteller = $clasSekolah->dataSekolah('aksesteller');

    if ($aksesteller == "ya") {
        echo "";
    } else {
        $rows .= "<td>" . $edit . "</td>";
    }


    $rows .= "<td>" . $format->entityEncode($data->nama) . "</td>";
    $rows .= "<td>" . $data->nis . "</td>";
    $rows .= "<td>" . $data->jenjang . "-" . $data->paralel . "</td>";
    $rows .= "<td>" . $hp_siswa . "</td>";
    //$rows .= "<td>" . $tanggungan . "</td>";
    //$rows .= "<td>" . $terbayar . "</td>";
    //$rows .= "<td>" . $kurang . "</td>";
    $rows .= "</tr>";
}

$pagination = '';
for ($i = 1; $i <= $totalPages; $i++) {
    if ($page == $i) {
        $pagination .= '<a href="#" class="pagination_link btn-xs btn-primary px-2 py-1 ml-1" data-page="' . $i . '">' . $i . '</a> ';
    } else {
        $pagination .= '<a href="#" class="pagination_link btn-xs btn-default px-2 py-1 ml-1" data-page="' . $i . '">' . $i . '</a> ';
    };
}

echo json_encode(['rows' => $rows, 'pagination' => $pagination, 'totalRecords' => $totalRows]);
