<?php
$view = new lembaga;
$format = new format;
$classTr = new transaksi;
$waktu = new time;

include "../../asset/bootstrap/asset/phpqrcode/qrlib.php";
require "../../asset/bootstrap/asset/fpdf/fpdf.php";

$tahun1 =  substr($tahun, 2, 2);
$tahun2 =  substr($tahun, 7, 2);
$nama_penerima = $classTr->namaPenerimaByID($data->penerima);

$code = "Pembayaran sejumlah " . $format->ribuan($jmlKuitansi) . " atas nama $data->nama NIS $data->nis INVOICE $id_tr pada " . $format->dateTimeToIndo($data->time) . " diterima oleh $nama_penerima";
QRCode::png($code, "view/transaksi/qrcode.png", "L", 4, 4);
$pdf = new FPDF('P', 'cm', 'A4');
$pdf->SetMargins(0.4, 0.0, 0.0);
$pdf->AliasNbPages();
$pdf->AddPage();
$pdf->SetFont('Arial', 'B', 11);

$pdf->Image($view->linkImageFPDF('view/transaksi/', 'qrcode'), 17.5, 2.7, 2, 2);
//$pdf->Image($view->linkImageFPDF('../../asset/dokumen/foto/', 'aks'), 17, 1, 1, 1);
$pdf->Image($view->linkImageFPDF('../../asset/dokumen/foto/', 'logo'), 1, 0.5, 1, 1);

$pdf->ln(0.5);
$pdf->SetFont('Arial', 'B', 12);
$pdf->Cell(2, 0.6, '', 0, 0, 'C');
$pdf->Cell(7, 0.6, $sekolah->dataSekolah('sekolah'), 0, 1, 'L');
$pdf->SetFont('Arial', 'I', 8);
$pdf->Cell(2, 0.3, '', 0, 0, 'C');
$pdf->Cell(7, 0.3, $sekolah->dataSekolah('alamat'), 0, 1, 'L');

$pdf->ln(0.2);
$pdf->SetFont('Arial', 'BU', 11);
$pdf->Cell(9, 0.6, '', 0, 0, 'C');
$pdf->Cell(10, 0.6, "BUKTI PEMBAYARAN TP. " . $tahun, 0, 1, 'R');
//$pdf->SetFont('Arial', 'B', 10);
//$pdf->Cell(9, 0.3, '', 0, 0, 'C');
//$pdf->Cell(7, 0.3, "TP. " . $tahun, 0, 1, 'R');
$pdf->SetFont('Arial', 'I', 8);
$pdf->Cell(9, 0.3, '', 0, 0, 'C');
$pdf->Cell(10, 0.3, "CETAK ULANG " . $format->dateTimeToIndo($waktu->getTime()), 0, 1, 'R');

$pdf->ln(0.5);

$pdf->SetFont('Arial', '', 9);
$pdf->Cell(0.7, 0.5, '', 0, 0, 'C');
$pdf->Cell(2, 0.5, 'NAMA', 0, 0, 'L');
$pdf->Cell(5.8, 0.5, ': ' . strtoupper($data->nama), 0, 0, 'L');

$pdf->Cell(0.7, 0.5, '', 0, 0, 'C');
$pdf->Cell(2, 0.5, 'INVOICE', 0, 0, 'L');
$pdf->Cell(7, 0.5, ': ' . $id_tr, 0, 1, 'L');


$pdf->Cell(0.7, 0.5, '', 0, 0, 'C');
$pdf->Cell(2, 0.5, 'NIS', 0, 0, 'L');
$pdf->Cell(5.8, 0.5, ': ' . strtoupper($data->nis), 0, 0, 'L');

$pdf->Cell(0.7, 0.5, '', 0, 0, 'C');
$pdf->Cell(2, 0.5, 'TIME', 0, 0, 'L');
$pdf->Cell(7, 0.5, ': ' . $format->dateTimeToIndo($data->time), 0, 1, 'L');

$pdf->Cell(0.7, 0.5, '', 0, 0, 'C');
$pdf->Cell(2, 0.5, 'KELAS', 0, 0, 'L');
$pdf->Cell(5.8, 0.5, ': ' . $data->jenjang . '-' . $data->paralel, 0, 0, 'L');

$pdf->Cell(0.7, 0.5, '', 0, 0, 'C');
$pdf->Cell(2, 0.5, 'METODE', 0, 0, 'L');
$pdf->Cell(7, 0.5, ': ' . $data->metode, 0, 1, 'L');

$pdf->Cell(0.7, 0.1, '', 0, 0, 'C');
$pdf->Cell(20, 0.1, '_______________________________________________________________________________________________________', 0, 1, 'L');

$pdf->ln(0.3);

$pdf->SetFont('Arial', 'B', 9);
$pdf->Cell(0.7, 0.1, '', 0, 0, 'C');
$pdf->Cell(1, 0.1, 'NO', 0, 0, 'C');
$pdf->Cell(7.5, 0.1, 'KDDE : JENIS PEMBAYARAN', 0, 0, 'L');
$pdf->Cell(2.5, 0.1, 'PERIODE', 0, 0, 'L');
$pdf->Cell(3, 0.1, 'JUMLAH', 0, 0, 'R');
$pdf->Cell(5, 0.1, 'KETERANGAN', 0, 1, 'L');

$pdf->Cell(0.7, 0.1, '', 0, 0, 'C');
$pdf->Cell(20, 0.1, '_______________________________________________________________________________________________________', 0, 1, 'L');

$pdf->ln(0.2);
$pdf->SetFont('Arial', '', 9);

$class = new transaksi();
$crud = new crudData();
$showList = $class->showTransaksiID($tb_transaksi, $id_tr);
$no = 1;
while ($dataTr = $showList->fetch(PDO::FETCH_OBJ)) {
    if ($dataTr->jumlah == "" || $dataTr->jumlah == 0) {
        $jumlah = number_format(0, 0, ",", ".");
    } else {
        $jumlah = number_format($dataTr->jumlah, 0, ",", ".");
    };

    $tahap = $dataTr->tahap;

    //startAt
    $startAt = $class->startAt($tb_siswa, $nis);
    $cekbulan = $class->cekPeriode($startAt, $tahap, $tahun1, $tahun2);

    //nama Bayar
    $classNB = new namaBayar();
    $ceknamaBayar = $classNB->ceknamaBayar($tahun, $dataTr->jenis, $dataTr->jenjang);

    $showJenis = $classNB->shownamaBayar($tahun, $dataTr->jenis, $dataTr->jenjang);
    $datajenis = $showJenis->fetch(PDO::FETCH_OBJ);
    $field_tang = 'tang_' . $datajenis->kode;
    $setbulanan = $datajenis->bulanan; //Cek Apakah Bulanan

    if ($setbulanan == "Tidak") {
        $periode = "Tahap " . $tahap;
    } else {
        $periode = $cekbulan;
    };

    $pdf->Cell(0.7, 0.5, '', 0, 0, 'C');
    $pdf->Cell(1, 0.5, $no, 0, 0, 'C');
    $pdf->Cell(7.5, 0.5, $dataTr->jenis . ' : ' . substr($ceknamaBayar, 0, 40), 0, 0, 'L');
    $pdf->Cell(2.5, 0.5, $periode, 0, 0, 'L');
    $pdf->Cell(3, 0.5, $jumlah, 0, 0, 'R');
    $pdf->Cell(5, 0.5, substr($dataTr->catatan, 0, 25), 0, 1, 'L');

    $no++;
}

$pdf->Cell(0.7, 0.1, '', 0, 0, 'C');
$pdf->Cell(20, 0.1, '_______________________________________________________________________________________________________', 0, 1, 'L');


$pdf->ln(0.3);

$pdf->SetFont('Arial', 'I', 8);
$pdf->Cell(1, 0.5, '', 0, 0, 'L');
$pdf->Cell(8.2, 0.5, 'Penerima : ' . $nama_penerima, 0, 0, 'L');
$pdf->SetFont('Arial', 'B', 11);
$pdf->Cell(2, 0.5, 'TOTAL', 0, 0, 'L');
$pdf->Cell(3.5, 0.5,  $format->ribuan($jmlKuitansi), 0, 1, 'R');



//Nama file ketika di print
$namaf = "view/transaksi/kuitansi_ulang.pdf";
$pdf->Output($namaf, "F");
