<div class="content-wrapper">

    <?php
    require('./layout/headerpage.php');

    $glob = new glob;
    $glob->delete('view/transaksi/', 'pdf');

    ?>

    <div class="container col-12 mb-4 pb-5">
        <div class="row">
            <div class="col-12">
                <div class="col-12">
                    <div class="card  mx-3">
                        <div class="timeline-header bg-primary  py-2 pl-2">
                            <b class="text-light judul"><span class="bi bi-list-columns-reverse"></span> Daftar Transaksi</b>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body my-4 mx-4">

                            <div class="div d-inline">
                                <a <?php echo $link->page('transaksi/transaksi_create_step1'); ?> class="btn btn-primary btn-xs mb-2 btn-rounded small px-2"> <i class="bi bi-file-earmark-plus"></i> REKAM TRANSAKSI</a>
                                <button id="deleteSelected" class="btn btn-primary btn-xs mb-2 btn-rounded small px-2"> <i class="bi bi-trash"></i> HAPUS</button>

                                <?php echo $link->exportXlsx('transaksi/transaksi_export', $tb_transaksi); ?>
                            </div>

                            <div class="row mt-2">
                                <label class="col-lg-1 col-sm-12 col-form-label text-primary mt-0 ">View </label>
                                <div class="col-lg-1 col-sm-12">
                                    <select id="limit" class="form-control form-control-sm fontInput small">
                                        <option value="50">50</option>
                                        <option value="100">100</option>
                                        <option value="200">200</option>
                                        <option value="500">500</option>
                                        <option value="1000">1000</option>

                                    </select>
                                </div>

                                <label class="col-lg-1 col-sm-12 col-form-label text-primary mt-0">Cari Transaksi </label>
                                <div class="col-lg-3 col-sm-12">
                                    <input type="text" id="search" placeholder="Uraian || No. Bukti || Tanggal (yyyy-mm-dd) " class="form-control form-control-sm fontInput">
                                </div>

                            </div>
                            <table class="table table-condensed table-sm mb-4 mt-3">
                                <thead>
                                    <tr>
                                        <th><input type='checkbox' id='checkAll' class='small'></th>
                                        <th width="50">Edit</th>
                                        <th width="100" data-sort="bukti" class="sortable">No. Bukti <span class="sort-icon" style="color: red;">⇅</span></th>
                                        <th data-sort="tanggal" class="sortable">Tanggal <span class="sort-icon" style="color: red;">⇅</span></th>
                                        <th>Uraian</th>
                                        <th width="150">Debet</th>
                                        <th width="150">Kredit</th>
                                        <th data-sort="jenis" class="sortable">Jns Transaksi <span class="sort-icon" style="color: red;">⇅</span></th>
                                        <th>Akun</th>
                                        <th>Kuitansi</th>
                                    </tr>
                                </thead>
                                <tbody id="dataTable"></tbody>
                            </table>
                            <div id="spinner">
                                <img src="../../asset/dokumen/foto/spinner2.gif" width="60" height="60" />
                                <p class="text-success"><i>Sedang memuat Data...</i></p>
                            </div>
                            <div id="recordInfo" class="mb-2"></div>
                            <div id="pagination"></div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
        </section>
    </div>
</div>


<script>
    $(document).ready(function() {
        let orderBy = "tanggal"; // Default kolom sorting
        let orderDir = "DESC"; // Default arah sorting

        function loadData(page = 1, limit = 50, search = '') {
            $('#spinner').show();
            $.ajax({
                url: 'view/transaksi/fetch/fetch_transaksi_read.php',
                type: 'GET',
                data: {
                    page,
                    limit,
                    search,
                    orderBy,
                    orderDir
                },
                success: function(data) {
                    const {
                        rows,
                        pagination,
                        totalRecords
                    } = JSON.parse(data);
                    $('#dataTable').html(rows);
                    $('#pagination').html(pagination);
                    $('#recordInfo').text(`Record : ${totalRecords} `);
                    $('#spinner').hide();
                }
            });
        }

        // Klik header untuk sorting
        $('.sortable').click(function() {
            let column = $(this).data("sort");
            if (orderBy === column) {
                orderDir = orderDir === "ASC" ? "DESC" : "ASC";
            } else {
                orderBy = column;
                orderDir = "ASC";
            }
            loadData(1, $('#limit').val(), $('#search').val());
        });

        $('#limit').change(function() {
            loadData(1, $(this).val(), $('#search').val());
        });

        $('#pagination').on('click', 'a', function(e) {
            e.preventDefault();
            const page = $(this).data('page');
            const limit = $('#limit').val();
            loadData(page, limit, $('#search').val());
        });

        $('#checkAll').click(function() {
            $('input[name="selectRow"]').prop('checked', this.checked);
        });

        $('#deleteSelected').click(function() {
            const ids = $('input[name="selectRow"]:checked').map(function() {
                return $(this).val();
            }).get();


            if (ids.length > 0) {
                $.post('view/transaksi/fetch/fetch_transaksi_delete.php', {
                    ids: ids

                }, function(response) {
                    const res = JSON.parse(response);
                    alert(res.message);
                    location.reload();
                    //load_data(); // Reload data setelah delete
                });
            } else {
                alert('Tidak Ada Data yang dipilih');
            }


        });


        $('#search').keyup(function() {
            loadData(1, $('#limit').val(), $(this).val());
        });

        loadData();
    });
</script>