<?php

require_once "../../../../../asset/mod/autoLoad.php";
require_once "../../../layout/conn.php";
require_once "../../../layout/session.php";

$crud = new crudData;
$link = new linkpage;

$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$limit = isset($_GET['limit']) ? (int)$_GET['limit'] : 5;
$search = isset($_GET['search']) ? $_GET['search'] : '';
$offset = ($page - 1) * $limit;
$orderBy = isset($_GET['orderBy']) ? $_GET['orderBy'] : 'tanggal';
$orderDir = isset($_GET['orderDir']) && $_GET['orderDir'] === 'ASC' ? 'ASC' : 'DESC';

// Pastikan kolom yang digunakan valid untuk mencegah SQL Injection
$validColumns = ['nama', 'tanggal', 'nis', 'penerima'];
if (!in_array($orderBy, $validColumns)) {
    $orderBy = 'tanggal';
}

//$query = "SELECT  * FROM  $tb_transaksi WHERE nama LIKE :search || nis LIKE :search order by tanggal desc, jenjang asc, paralel asc, nama asc LIMIT :limit OFFSET :offset";
$query = "SELECT  * FROM  $tb_transaksi WHERE nama LIKE :search || nis LIKE :search order by $orderBy $orderDir  LIMIT :limit OFFSET :offset";

$stmt = $pdo->prepare($query);
$stmt->bindValue(':search', "%$search%", PDO::PARAM_STR);
$stmt->bindValue(':limit', $limit, PDO::PARAM_INT);
$stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
$stmt->execute();

//$datas = $stmt->fetchAll(PDO::FETCH_ASSOC);
$datas = $stmt->fetchAll(PDO::FETCH_OBJ);

$total = $pdo->prepare("SELECT COUNT(*) FROM $tb_transaksi WHERE nama LIKE :search OR nis LIKE :search");
$total->bindValue(':search', "%$search%", PDO::PARAM_STR);
$total->execute();
$totalRows = $total->fetchColumn();
$totalPages = ceil($totalRows / $limit);

$rows = '';
foreach ($datas as $data) {


    $format = new format();

    $nis = $data->nis;
    $tahap = $data->tahap;

    //startAt
    $classTr = new transaksi();
    $startAt = $classTr->startAt($tb_siswa, $nis);
    $cekbulan = $classTr->cekPeriode($startAt, $tahap, $tahun1, $tahun2);

    //nama Bayar
    $classNB = new namaBayar();

    $namaBayar = $classNB->ceknamaBayar($tahun, $data->jenis, $data->jenjang);
    $showJenis = $classNB->shownamaBayar($tahun, $data->jenis, $data->jenjang);
    $datajenis = $showJenis->fetch(PDO::FETCH_OBJ);

    $countCodeBayar = $crud->countData('tb_nama_bayar', "where kode='$data->jenis' and tp='{$tahun}' and kelas='{$data->jenjang}'");

    if ($countCodeBayar > 0) {
        $field_tang = 'tang_' . $datajenis->kode;
        $setbulanan = $datajenis->bulanan; //Cek Apakah Bulanan
    } else {
        $field_tang = "";
        $setbulanan = "";
    }

    if ($setbulanan == "Tidak") {
        $periode = "Tahap " . $tahap;
    } else {
        $periode = $cekbulan;
    };

    //Proses Setor
    $clsSetor = new setor;
    //$modal = new modal;
    $statusSetor = $clsSetor->statusSetor($data->setor);

    $link = new linkpage;
    $penerima = $classTr->namaPenerimaByID($data->penerima);
    $checkbox = "<input type='checkbox' class='delete-checkbox d-inline small' name='selectRow' value='{$data->id}'>";
    if ($data->setor != "") {
        $check = "";
    } else {
        $check = $checkbox;
    };

    if ($level == "admin") {
        $edit = "<td width='75px' align='center'>
        <a " . $link->pageID($data->id, 'transaksi/transaksi_edit') . " class='badge badge-warning  px-1 py-1 d-inline''> <i class='bi bi-pencil-square'></i> EDIT</a>
        </td>";
    } else {
        $edit = "";
    };

    $rows .= "<tr>";
    $rows .= "<td width='5px'>$check</td>";
    $rows .= "<td>" . $format->dateToIndo($data->tanggal) . "</td>";
    $rows .= "<td>" . $format->entityEncode($data->nama) . "</td>";
    $rows .= "<td>" . $data->nis . "</td>";
    $rows .= "<td>" . $data->jenjang . "-" . $data->paralel . "</td>";
    $rows .= "<td>" . $data->jenis . "-" . $namaBayar . "</td>";
    $rows .= "<td>" . $data->tahap . "</td>";
    $rows .= "<td>" .  $format->ribuan($data->jumlah) . "</td>";
    $rows .= "<td>" . $data->metode . "</td>";
    $rows .= "<td>" . $penerima . "</td>";
    $rows .= "<td>" . $data->catatan . "</td>";
    $rows .= $edit;
    $rows .= "</tr>";
}

$pagination = '';
for ($i = 1; $i <= $totalPages; $i++) {
    if ($page == $i) {
        $pagination .= '<a href="#" class="pagination_link btn-xs btn-primary mx-1 my-1 " data-page="' . $i . '">' . $i . '</a> ';
    } else {
        $pagination .= '<a href="#" class="pagination_link btn-xs btn-default mx-1 my-1 " data-page="' . $i . '">' . $i . '</a> ';
    };
}

echo json_encode(['rows' => $rows, 'pagination' => $pagination, 'totalRecords' => $totalRows]);
