<?php

error_reporting(1);
require_once "../../../../../asset/mod/autoLoad.php";
require_once "../../../layout/conn.php";
require_once "../../../layout/session.php";

$crud = new crudData;
$link = new linkpage;
$setor = new setor();
$format = new format();
$modal = new modal();
$classNB = new namaBayar();
$classTr = new transaksi();

$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$limit = isset($_GET['limit']) ? (int)$_GET['limit'] : 5;
$search = isset($_GET['search']) ? $_GET['search'] : '';
$offset = ($page - 1) * $limit;
$orderBy = isset($_GET['orderBy']) ? $_GET['orderBy'] : 'tanggal_draf';
$orderDir = isset($_GET['orderDir']) && $_GET['orderDir'] === 'ASC' ? 'ASC' : 'DESC';

$jenjang = isset($_GET['jenjang']) ? $_GET['jenjang'] : Null;
$status = isset($_GET['status']) ? $_GET['status'] : Null;
$jenis = isset($_GET['jenis']) ? $_GET['jenis'] : Null;

$idUser = isset($_GET['idUser']) ? $_GET['idUser'] : '';
$level = $crud->getValue('user', "where id='$idUser'", 'level');
//if ($level == "admin") {
//    $filterUser = "";
//} else {
//    $filterUser = "and penyetor='$idUser'";
//};


// Pastikan kolom yang digunakan valid untuk mencegah SQL Injection
$validColumns = ['tanggal', 'setor'];
if (!in_array($orderBy, $validColumns)) {
    $orderBy = 'tanggal';
}

if ($jenjang == "Semua") {
    $filterJenjang = "";
} else {
    $filterJenjang = "and jenjang='$jenjang'";;
};

if ($status == "Semua") {
    $filterStatus = "";
} elseif ($status == 0) {
    $filterStatus = "and (setor='0' OR setor='')";
} else {
    $filterStatus = "and setor='$status'";
};

if ($jenis == "Semua") {
    $filterJenis = "";
} else {
    $filterJenis = "and jenis='$jenis'";;
};

$query = "SELECT * FROM $tb_transaksi WHERE (nama LIKE :search OR nis LIKE :search OR catatan LIKE :search) $filterJenjang $filterStatus $filterJenis ORDER BY $orderBy $orderDir LIMIT :limit OFFSET :offset";

$stmt = $pdo->prepare($query);
$stmt->bindValue(':search', "%$search%", PDO::PARAM_STR);
$stmt->bindValue(':limit', $limit, PDO::PARAM_INT);
$stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
$stmt->execute();

//$datas = $stmt->fetchAll(PDO::FETCH_ASSOC);
$datas = $stmt->fetchAll(PDO::FETCH_OBJ);

$total = $pdo->prepare("SELECT COUNT(*) FROM $tb_transaksi WHERE (nama LIKE :search OR nis LIKE :search) $filterJenjang $filterStatus $filterJenis");
$total->bindValue(':search', "%$search%", PDO::PARAM_STR);
$total->execute();
$totalRows = $total->fetchColumn();
$totalPages = ceil($totalRows / $limit);

$rows = '';
foreach ($datas as $data) {

    $tanggal = $format->dateToIndo($data->tanggal);
    $namaBayar = $classNB->ceknamaBayar($tahun, $data->jenis, $data->jenjang);

    $penerima = $classTr->namaPenerimaByID($data->penerima);
    $penyetor = $classTr->namaPenerimaByID($crud->getValue($tb_setor, "where id_setor='$data->id_setor'", 'penyetor'));

    $status = $setor->statusSetor($data->setor);

    $countSetor = $crud->countData($tb_setor, "where id_setor='$data->id_setor'");
    if ($countSetor < 1 and $data->setor >= 2) {
        $rowColor = 'table-danger';
    } else {
        $rowColor = 'table-default';
    };


    if ($data->setor < 1) {
        $reset = "<b class='text-default'><i>---</i></b>";
    } elseif ($data->setor > 2) {
        $reset = "<b class='text-success'><i>---</i></b>";
    } elseif ($level == "admin" and ($data->setor == 1 or $data->setor == 2)) {
        $reset = "<form name='cetak' action='" . $link->pageAction('setor/setor_page_reset') . "' method='post'>
            <input name='id_setor' value='" . $data->id_setor . "' hidden>
            <input name='id_tr' value='" . $data->id . "' hidden>
            <input name='tahun' value='" . $tahun . "' hidden>
            <button type='submit' class='btn btn-default btn-xs'><i class='bi bi-arrow-counterclockwise text-danger'></i><b class='text-danger'> RESET / HAPUS</b></button>
            </form>";
    } elseif ($level != "admin" and $data->penerima == $idUser and ($data->setor == 1 or $data->setor == 2)) {
        $reset = "<form name='cetak' action='" . $link->pageAction('setor/setor_page_reset') . "' method='post'>
            <input name='id_setor' value='" . $data->id_setor . "' hidden>
            <input name='id_tr' value='" . $data->id . "' hidden>
            <input name='tahun' value='" . $tahun . "' hidden>
            <button type='submit' class='btn btn-default btn-xs'><i class='bi bi-arrow-counterclockwise text-danger'></i><b class='text-danger'> RESET / HAPUS</b></button>
            </form>";
    } elseif ($level != "admin" and $data->penerima != $idUser and ($data->setor == 1 or $data->setor == 2)) {
        $reset = "<form name='cetak' action='" . $link->pageAction('setor/setor_page_reset') . "' method='post'>
            <input name='id_setor' value='" . $data->id_setor . "' hidden>
            <input name='id_tr' value='" . $data->id . "' hidden>
            <input name='tahun' value='" . $tahun . "' hidden>
            <button type='submit' class='btn btn-default btn-xs' disabled><i class='bi bi-arrow-counterclockwise text-default'></i><b class='text-default'> RESET / HAPUS</b></button>
            </form>";
    } else {
        $reset = "";
    };


    $no++;
    $rows .= "<tr class='$rowColor'>";
    $rows .= "<td width='5px'>$no</td>";
    $rows .= "<td align=left>" . $format->dateToIndo($data->tanggal) . $totalRows . "</td>";
    $rows .= "<td align=left>" . strtoupper($data->nama) . "</td>";
    $rows .= "<td align=left>$data->nis</td>";
    $rows .= "<td align=left>$data->jenjang-$data->paralel</td>";
    $rows .= "<td align=left>" . $data->jenis . "-" . $namaBayar . "</td>";
    $rows .= "<td align=left>$data->tahap</td>";
    $rows .= "<td align=right>" . $format->ribuan($data->jumlah) . "</td>";
    $rows .= "<td align=left>$data->metode</td>";
    $rows .= "<td align=left>$penerima</td>";
    $rows .= "<td align=left>$penyetor</td>";
    $rows .= "<td align=left><b class='text-success'>" . strtoupper($data->id_setor) . "</b></td>";
    $rows .= "<td align=left><div style='display: flex; gap: 5px;'>$status</div></td>";
    $rows .= "<td align=left>$reset</td>";
    $rows .= "</tr>";
}

$pagination = '';
for ($i = 1; $i <= $totalPages; $i++) {
    if ($page == $i) {
        $pagination .= '<a href="#" class="pagination_link btn-xs btn-primary mx-1 my-1 " data-page="' . $i . '">' . $i . '</a> ';
    } else {
        $pagination .= '<a href="#" class="pagination_link btn-xs btn-default mx-1 my-1 " data-page="' . $i . '">' . $i . '</a> ';
    };
}

echo json_encode(['rows' => $rows, 'pagination' => $pagination, 'totalRecords' => $totalRows]);
