<?php

require_once "../../../../../../asset/mod/autoLoad.php";
require_once "../../../../layout/conn.php";
require_once "../../../../layout/session.php";

$crud = new crudData;
$link = new linkpage;
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$limit = isset($_GET['limit']) ? (int)$_GET['limit'] : 5;
$search = isset($_GET['search']) ? $_GET['search'] : '';
$offset = ($page - 1) * $limit;


$query = "SELECT * FROM $tb_siswa WHERE nama LIKE :search || nis LIKE :search LIMIT :limit OFFSET :offset";
$stmt = $pdo->prepare($query);
$stmt->bindValue(':search', "%$search%", PDO::PARAM_STR);
$stmt->bindValue(':limit', $limit, PDO::PARAM_INT);
$stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
$stmt->execute();

$datas = $stmt->fetchAll(PDO::FETCH_OBJ);

$total = $pdo->prepare("SELECT COUNT(*) FROM $tb_siswa WHERE nama LIKE :search OR nis LIKE :search");
$total->bindValue(':search', "%$search%", PDO::PARAM_STR);
$total->execute();
$totalRows = $total->fetchColumn();
$totalPages = ceil($totalRows / $limit);

$rows = '';
foreach ($datas as $data) {

    $id = $data->id;
    $hp_siswa = $data->hp;
    $nis = $data->nis;



    if ($id == "") {
        $edit = "No ID";
    } else {
        $edit = "<a " . $link->pageID($id, 'seting/siswa/siswa_edit') . " class='badge badge-primary  px-1 py-1 d-inline' > <i class='bi bi-pencil-square'></i> EDIT</a>";
    };

    //Cek NIS Dobel
    $countNIS = $crud->countData($tb_siswa, " where nis='$nis'");

    if ($countNIS > 1) {
        $bgColor = "red";
    } else {
        $bgColor = "";
    };

    $rows .= "<tr bgcolor='$bgColor'>";
    $rows .= "<td width='5px'><input type='checkbox' class='delete-checkbox d-inline small' name='selectRow' value='{$data->id}'></td>";
    $rows .= "<td>" . $edit . "</td>";
    $rows .= "<td>" . $data->nis . "</td>";
    $rows .= "<td>" . $format->entityEncode($data->nama) . "</td>";
    $rows .= "<td>" . $data->jenjang . "-" . $data->paralel . "</td>";
    $rows .= "<td>" . $hp_siswa . "</td>";
    $rows .= "<td><a " . $link->pageID($id, 'transaksi/transaksi_create') . " class='badge badge-success  px-1 py-1 d-inline'> <i class='bi bi-credit-card-2-back'></i>  PILIH->BAYAR</a></td>";
    $rows .= "<td><a " . $link->pageIDReportSiswa($id, 'seting/siswa/buku_preview', $nis, $tahun) . " class='badge badge-secondary  px-1 py-1 d-inline''> <i class='bi bi-printer'></i> BUKU PEMBAYARAN</a></td>";
    //$rows .= "<td><a " . $link->pageID($data->id, 'seting/siswa/uploadFoto') . " class='badge badge-" . $colorUpload . "  px-1 py-1 d-inline''> <i class='bi bi-cloud-arrow-up'></i> UPLOAD</a></td>";
    $rows .= "</tr>";
}


$pagination = '';
for ($i = 1; $i <= $totalPages; $i++) {
    if ($page == $i) {
        $pagination .= '<a href="#" class="pagination_link btn-xs btn-primary px-2 py-1 ml-1" data-page="' . $i . '">' . $i . '</a> ';
    } else {
        $pagination .= '<a href="#" class="pagination_link btn-xs btn-default px-2 py-1 ml-1" data-page="' . $i . '">' . $i . '</a> ';
    };
}

echo json_encode(['rows' => $rows, 'pagination' => $pagination, 'totalRecords' => $totalRows]);
