<?php

//Hak Cipta dilindungi Undang-undang. Hak Cipta : Khamdi Rahmani, Reg. Kemenkum HAM No : 000121327. Dilarang merubah isi File tanpa ijin tertulis dari pemegang Hak Cipta. 

//class transaksi extends crudData
class transaksi
{
    function IPnya()
    {
        $ipaddress = '';
        if (getenv('HTTP_CLIENT_IP'))
            $ipaddress = getenv('HTTP_CLIENT_IP');
        else if (getenv('HTTP_X_FORWARDED_FOR'))
            $ipaddress = getenv('HTTP_X_FORWARDED_FOR');
        else if (getenv('HTTP_X_FORWARDED'))
            $ipaddress = getenv('HTTP_X_FORWARDED');
        else if (getenv('HTTP_FORWARDED_FOR'))
            $ipaddress = getenv('HTTP_FORWARDED_FOR');
        else if (getenv('HTTP_FORWARDED'))
            $ipaddress = getenv('HTTP_FORWARDED');
        else if (getenv('REMOTE_ADDR'))
            $ipaddress = getenv('REMOTE_ADDR');
        else
            $ipaddress = 'IP Tidak Dikenali';
        return $ipaddress;
    }

    public function showTransaksiID($tableName, $id_tr)
    {
        $db = database::getInstance();
        $result = $db->runQuery("SELECT * FROM " . $tableName . " WHERE id_tr='" . $id_tr . "' order by jenis asc, tahap asc");
        $jmldata = $result->rowCount();
        return $result;
    }

    public function showTransaksiSiswa($tableName, $nis)
    {
        $db = database::getInstance();
        $result = $db->runQuery("SELECT * FROM " . $tableName . " WHERE nis='" . $nis . "' order by tanggal asc, jenis asc, tahap asc");
        $jmldata = $result->rowCount();
        return $result;
    }


    public function jenisBayar($tahun, $kode)
    {
        $db = database::getInstance();
        $jenisBayar = $db->runQuery("SELECT * FROM tb_nama_bayar WHERE tp='{$tahun}' and kode='{$kode}'");
        $data = $jenisBayar->fetch(PDO::FETCH_OBJ);
        $bulanan = $data->bulanan;
        return $bulanan;
    }

    public function startAt($tb_siswa, $nis)
    {
        $clscrud = new crudData();
        $v_startAt = $clscrud->getValue($tb_siswa, " where nis='$nis'", 'startAt');
        if ($v_startAt  == "") {
            $startAt = 1;
        } else {
            $startAt = $v_startAt;
        };
        return $startAt;
    }

    public function tahap($tableName, $jenis, $nis, $startAt, $tahun, $kode)
    {
        $db = database::getInstance();
        //s.d Tahap Lalu
        $tahaplalu = $db->runQuery("SELECT * FROM {$tableName} where jenis='{$jenis}' and nis='{$nis}'")->rowCount();

        //tahap ini
        $result = $db->runQuery("SELECT max(tahap) as max_tahap FROM {$tableName} where jenis='{$jenis}' and nis='{$nis}'");
        while ($tahapmax = $result->fetch()) {
            $tahap = $tahapmax['max_tahap'] + 1;
        };

        $bulanan = $this->jenisBayar($tahun, $kode);

        if (($bulanan == "Ya" or $bulanan == "ya") and $startAt == 1 and $tahaplalu == 0) {
            $in_tahap = $tahap;
        } elseif (($bulanan == "Ya" or $bulanan == "ya") and $startAt > 1  and $tahaplalu == 0) {
            $in_tahap = ($tahap + $startAt) - 1;
        } else {
            $in_tahap = $tahap;
        };

        return $in_tahap;
    }

    public function penerima($username)
    {
        $db = database::getInstance();
        $user = $db->runQuery("SELECT * FROM user WHERE username='{$username}'");
        $data = $user->fetch(PDO::FETCH_OBJ);
        $penerima = $data->id;
        return $penerima;
    }
    public function namaPenerimaByID($id)
    {
        $crud = new crudData;
        $penerima = $crud->getValue('user', "where id='$id' || id_user='$id'", 'nama');
        return $penerima;
    }


    //public function infoterbayar($tableName, $nis, $jenis)
    //{
    //    $db = database::getInstance();
    //    $show = $db->runQuery("SELECT SUM(jumlah)  * FROM {$tableName}  WHERE nis = '$nis' and jenis='$jenis'");
    //    $data = $show->fetch();
    //    $value = $data[0];
    //    return $value;
    //}

    public function infoterbayar($tableName, $nis, $jenis)
    {
        $db = database::getInstance();
        $show = $db->runQuery("SELECT SUM(jumlah)   FROM {$tableName}  WHERE nis = '$nis' and jenis='$jenis'");
        $data = $show->fetch();
        $value = $data[0];
        return $value;
    }

    public function infoterbayarOnTahap($tableName, $nis, $jenis, $tahap1, $tahap2)
    {
        $db = database::getInstance();
        $show = $db->runQuery("SELECT SUM(jumlah)  FROM {$tableName}  WHERE nis = '$nis' and jenis='$jenis' and tahap>='$tahap1' and tahap<='$tahap2'");
        $data = $show->fetch();
        $value = $data[0];
        return $value;
    }

    public function infoterbayarOnTahapforAll($tahun, $kolom, $jenjang, $table, $nis, $jenis, $tahap1, $tahap2)
    {
        $db = database::getInstance();
        //bulanan?
        $namaBayar = new namaBayar();
        $bulanan = $namaBayar->cekBulanan($tahun, $kolom, $jenjang);

        $show = $db->runQuery("SELECT SUM(jumlah)  FROM {$table}  WHERE nis = '$nis' and jenis='$jenis' and tahap>='$tahap1' and tahap<='$tahap2'");
        $data = $show->fetch();
        $value = $data[0];
        if ($bulanan == 1) {
            $value = $value;
        } else {
            $value = 0;
        };
        return $value;
    }


    public function infoterbayarOnTahapAllJenis($tahun, $jenjang, $table, $nis, $kode, $tahap1, $tahap2)
    {
        if ($kode != "Semua") {
            $value = $this->infoterbayarOnTahap($table, $nis, $kode, $tahap1, $tahap2);
        } else {
            $a = $this->infoterbayarOnTahapforAll($tahun, 'A', $jenjang, $table, $nis, 'A', $tahap1, $tahap2);
            $b = $this->infoterbayarOnTahapforAll($tahun, 'B', $jenjang, $table, $nis, 'B', $tahap1, $tahap2);
            $c = $this->infoterbayarOnTahapforAll($tahun, 'C', $jenjang, $table, $nis, 'C', $tahap1, $tahap2);
            $d = $this->infoterbayarOnTahapforAll($tahun, 'D', $jenjang, $table, $nis, 'D', $tahap1, $tahap2);
            $e = $this->infoterbayarOnTahapforAll($tahun, 'E', $jenjang, $table, $nis, 'E', $tahap1, $tahap2);
            $f = $this->infoterbayarOnTahapforAll($tahun, 'F', $jenjang, $table, $nis, 'F', $tahap1, $tahap2);
            $g = $this->infoterbayarOnTahapforAll($tahun, 'G', $jenjang, $table, $nis, 'G', $tahap1, $tahap2);
            $h = $this->infoterbayarOnTahapforAll($tahun, 'H', $jenjang, $table, $nis, 'H', $tahap1, $tahap2);
            $i = $this->infoterbayarOnTahapforAll($tahun, 'I', $jenjang, $table, $nis, 'I', $tahap1, $tahap2);
            $j = $this->infoterbayarOnTahapforAll($tahun, 'J', $jenjang, $table, $nis, 'J', $tahap1, $tahap2);
            $k = $this->infoterbayarOnTahapforAll($tahun, 'K', $jenjang, $table, $nis, 'K', $tahap1, $tahap2);
            $l = $this->infoterbayarOnTahapforAll($tahun, 'L', $jenjang, $table, $nis, 'L', $tahap1, $tahap2);
            $m = $this->infoterbayarOnTahapforAll($tahun, 'M', $jenjang, $table, $nis, 'M', $tahap1, $tahap2);
            $n = $this->infoterbayarOnTahapforAll($tahun, 'N', $jenjang, $table, $nis, 'N', $tahap1, $tahap2);
            $o = $this->infoterbayarOnTahapforAll($tahun, 'O', $jenjang, $table, $nis, 'O', $tahap1, $tahap2);
            $p = $this->infoterbayarOnTahapforAll($tahun, 'P', $jenjang, $table, $nis, 'P', $tahap1, $tahap2);
            $q = $this->infoterbayarOnTahapforAll($tahun, 'Q', $jenjang, $table, $nis, 'Q', $tahap1, $tahap2);
            $r = $this->infoterbayarOnTahapforAll($tahun, 'R', $jenjang, $table, $nis, 'R', $tahap1, $tahap2);
            $s = $this->infoterbayarOnTahapforAll($tahun, 'S', $jenjang, $table, $nis, 'S', $tahap1, $tahap2);
            $t = $this->infoterbayarOnTahapforAll($tahun, 'T', $jenjang, $table, $nis, 'T', $tahap1, $tahap2);
            $u = $this->infoterbayarOnTahapforAll($tahun, 'U', $jenjang, $table, $nis, 'U', $tahap1, $tahap2);
            $v = $this->infoterbayarOnTahapforAll($tahun, 'V', $jenjang, $table, $nis, 'V', $tahap1, $tahap2);
            $w = $this->infoterbayarOnTahapforAll($tahun, 'W', $jenjang, $table, $nis, 'W', $tahap1, $tahap2);
            $x = $this->infoterbayarOnTahapforAll($tahun, 'X', $jenjang, $table, $nis, 'X', $tahap1, $tahap2);
            $y = $this->infoterbayarOnTahapforAll($tahun, 'Y', $jenjang, $table, $nis, 'Y', $tahap1, $tahap2);
            $z = $this->infoterbayarOnTahapforAll($tahun, 'Z', $jenjang, $table, $nis, 'Z', $tahap1, $tahap2);

            $value = @($a + $b + $c + $d + $e + $f + $g + $h + $i + $j + $k + $l + $m + $n + $o + $p + $q + $r + $s + $t + $u + $v + $w + $x + $y + $z);
        }
        return $value;
    }
    //SUM REKAP REPORT BULANAN
    public function infoterbayarOnTahapOnSUM($table, $tb_siswa, $jenjang, $paralel, $status, $jenis, $tahap1, $tahap2)
    {
        if ($jenjang == "Semua" and $paralel == "Semua") {
            $where = "$table.jenjang!=''";
        } elseif ($jenjang == "Semua" and $paralel != "Semua") {
            $where = "$table.jenjang!='' and $table.paralel='{$paralel}'";
        } elseif ($jenjang != "Semua" and $paralel == "Semua") {
            $where = "$table.jenjang='{$jenjang}'";
        } elseif ($jenjang != "Semua" and $paralel != "Semua") {
            $where = "$table.jenjang='{$jenjang}' and $table.paralel='{$paralel}'";
        } else {
            $where = "$table.jenjang!=''";
        };


        if ($status == "Semua") {
            $where_status = "";
        } else {
            $where_status = "and $tb_siswa.status='{$status}'";
        };

        $db = database::getInstance();
        // $show = $db->runQuery("SELECT SUM(jumlah)  FROM {$table}  WHERE $where and jenis='$jenis' and tahap>='$tahap1' and tahap<='$tahap2'");
        $show = $db->runQuery("SELECT SUM(jumlah) As TOTAL FROM {$table} LEFT JOIN {$tb_siswa} ON " . $tb_siswa . ".nis = " . $table . ".nis  WHERE $where  and jenis='$jenis' and tahap>='$tahap1' and tahap<='$tahap2' $where_status");

        $data = $show->fetch();
        $value = $data[0];
        return $value;
    }

    public function infoterbayarOnTahapforAllOnSUM($tahun, $kolom, $jenjang, $paralel, $status, $table, $tb_siswa, $jenis, $tahap1, $tahap2)
    {
        if ($jenjang == "Semua" and $paralel == "Semua") {
            $where = "$table.jenjang!=''";
        } elseif ($jenjang == "Semua" and $paralel != "Semua") {
            $where = "$table.jenjang!='' and $table.paralel='{$paralel}'";
        } elseif ($jenjang != "Semua" and $paralel == "Semua") {
            $where = "$table.jenjang='{$jenjang}'";
        } elseif ($jenjang != "Semua" and $paralel != "Semua") {
            $where = "$table.jenjang='{$jenjang}' and $table.paralel='{$paralel}'";
        } else {
            $where = "$table.jenjang!=''";
        };


        if ($status == "Semua") {
            $where_status = "";
        } else {
            $where_status = "and $tb_siswa.status='{$status}'";
        };

        $db = database::getInstance();
        //bulanan?
        $namaBayar = new namaBayar();
        $bulanan = $namaBayar->cekBulanan($tahun, $kolom, $jenjang);

        //$show = $db->runQuery("SELECT SUM(jumlah)  FROM {$table}  WHERE  $where and jenis='$jenis' and tahap>='$tahap1' and tahap<='$tahap2'");
        $show = $db->runQuery("SELECT SUM(jumlah) As TOTAL FROM {$table} LEFT JOIN {$tb_siswa} ON " . $tb_siswa . ".nis = " . $table . ".nis  WHERE $where  and jenis='$jenis' and tahap>='$tahap1' and tahap<='$tahap2' $where_status");

        $data = $show->fetch();
        $value = $data[0];
        if ($bulanan == 1) {
            $value = $value;
        } else {
            $value = 0;
        };
        return $value;
    }

    public function infoterbayarOnTahapAllJenisOnSUM($tahun, $jenjang, $paralel, $status, $table, $tb_siswa, $kode, $tahap1, $tahap2)
    {
        if ($kode != "Semua") {
            $value = $this->infoterbayarOnTahapOnSUM($table, $tb_siswa, $jenjang, $paralel, $status, $kode, $tahap1, $tahap2);
        } else {
            $a = $this->infoterbayarOnTahapforAllOnSUM($tahun, 'A', $jenjang, $paralel, $status, $table, $tb_siswa, 'A', $tahap1, $tahap2);
            $b = $this->infoterbayarOnTahapforAllOnSUM($tahun, 'B', $jenjang, $paralel, $status, $table, $tb_siswa, 'B', $tahap1, $tahap2);
            $c = $this->infoterbayarOnTahapforAllOnSUM($tahun, 'C', $jenjang, $paralel, $status, $table, $tb_siswa, 'C', $tahap1, $tahap2);
            $d = $this->infoterbayarOnTahapforAllOnSUM($tahun, 'D', $jenjang, $paralel, $status, $table, $tb_siswa, 'D', $tahap1, $tahap2);
            $e = $this->infoterbayarOnTahapforAllOnSUM($tahun, 'E', $jenjang, $paralel, $status, $table, $tb_siswa, 'E', $tahap1, $tahap2);
            $f = $this->infoterbayarOnTahapforAllOnSUM($tahun, 'F', $jenjang, $paralel, $status, $table, $tb_siswa, 'F', $tahap1, $tahap2);
            $g = $this->infoterbayarOnTahapforAllOnSUM($tahun, 'G', $jenjang, $paralel, $status, $table, $tb_siswa, 'G', $tahap1, $tahap2);
            $h = $this->infoterbayarOnTahapforAllOnSUM($tahun, 'H', $jenjang, $paralel, $status, $table, $tb_siswa, 'H', $tahap1, $tahap2);
            $i = $this->infoterbayarOnTahapforAllOnSUM($tahun, 'I', $jenjang, $paralel, $status, $table, $tb_siswa, 'I', $tahap1, $tahap2);
            $j = $this->infoterbayarOnTahapforAllOnSUM($tahun, 'J', $jenjang, $paralel, $status, $table, $tb_siswa, 'J', $tahap1, $tahap2);
            $k = $this->infoterbayarOnTahapforAllOnSUM($tahun, 'K', $jenjang, $paralel, $status, $table, $tb_siswa, 'K', $tahap1, $tahap2);
            $l = $this->infoterbayarOnTahapforAllOnSUM($tahun, 'L', $jenjang, $paralel, $status, $table, $tb_siswa, 'L', $tahap1, $tahap2);
            $m = $this->infoterbayarOnTahapforAllOnSUM($tahun, 'M', $jenjang, $paralel, $status, $table, $tb_siswa, 'M', $tahap1, $tahap2);
            $n = $this->infoterbayarOnTahapforAllOnSUM($tahun, 'N', $jenjang, $paralel, $status, $table, $tb_siswa, 'N', $tahap1, $tahap2);
            $o = $this->infoterbayarOnTahapforAllOnSUM($tahun, 'O', $jenjang, $paralel, $status, $table, $tb_siswa, 'O', $tahap1, $tahap2);
            $p = $this->infoterbayarOnTahapforAllOnSUM($tahun, 'P', $jenjang, $paralel, $status, $table, $tb_siswa, 'P', $tahap1, $tahap2);
            $q = $this->infoterbayarOnTahapforAllOnSUM($tahun, 'Q', $jenjang, $paralel, $status, $table, $tb_siswa, 'Q', $tahap1, $tahap2);
            $r = $this->infoterbayarOnTahapforAllOnSUM($tahun, 'R', $jenjang, $paralel, $status, $table, $tb_siswa, 'R', $tahap1, $tahap2);
            $s = $this->infoterbayarOnTahapforAllOnSUM($tahun, 'S', $jenjang, $paralel, $status, $table, $tb_siswa, 'S', $tahap1, $tahap2);
            $t = $this->infoterbayarOnTahapforAllOnSUM($tahun, 'T', $jenjang, $paralel, $status, $table, $tb_siswa, 'T', $tahap1, $tahap2);
            $u = $this->infoterbayarOnTahapforAllOnSUM($tahun, 'U', $jenjang, $paralel, $status, $table, $tb_siswa, 'U', $tahap1, $tahap2);
            $v = $this->infoterbayarOnTahapforAllOnSUM($tahun, 'V', $jenjang, $paralel, $status, $table, $tb_siswa, 'V', $tahap1, $tahap2);
            $w = $this->infoterbayarOnTahapforAllOnSUM($tahun, 'W', $jenjang, $paralel, $status, $table, $tb_siswa, 'W', $tahap1, $tahap2);
            $x = $this->infoterbayarOnTahapforAllOnSUM($tahun, 'X', $jenjang, $paralel, $status, $table, $tb_siswa, 'X', $tahap1, $tahap2);
            $y = $this->infoterbayarOnTahapforAllOnSUM($tahun, 'Y', $jenjang, $paralel, $status, $table, $tb_siswa, 'Y', $tahap1, $tahap2);
            $z = $this->infoterbayarOnTahapforAllOnSUM($tahun, 'Z', $jenjang, $paralel, $status, $table, $tb_siswa, 'Z', $tahap1, $tahap2);

            $value = @($a + $b + $c + $d + $e + $f + $g + $h + $i + $j + $k + $l + $m + $n + $o + $p + $q + $r + $s + $t + $u + $v + $w + $x + $y + $z);
        }
        return $value;
    }


    public function sumTerbayar($tableName, $jenjang, $paralel, $jenis) //report Rekapitulasi-1
    {
        if ($jenjang == "Semua" and $paralel == "Semua") {
            $where = "jenjang!=''";
        } elseif ($jenjang == "Semua" and $paralel != "Semua") {
            $where = "paralel='{$paralel}'";
        } elseif ($jenjang != "Semua" and $paralel == "Semua") {
            $where = "jenjang='{$jenjang}'";
        } elseif ($jenjang != "Semua" and $paralel != "Semua") {
            $where = "jenjang='{$jenjang}' and paralel='{$paralel}'";
        } else {
            $where = "jenjang!=''";
        };

        if ($jenis == "Semua") {
            $where_jenis = "and jenis!=''";
        } else {
            $where_jenis = "and jenis='{$jenis}'";
        };

        $db = database::getInstance();
        $show = $db->runQuery("SELECT SUM(jumlah)  FROM {$tableName}  WHERE $where $where_jenis");
        $data = $show->fetch();
        $value = $data[0];
        return $value;
    }
    public function sumTerbayarRekap($tableName, $tb_siswa, $jenjang, $paralel, $status, $jenis) //report Rekapitulasi-1 Update
    {
        if ($jenjang == "Semua" and $paralel == "Semua") {
            $where = "$tableName.jenjang!=''";
        } elseif ($jenjang == "Semua" and $paralel != "Semua") {
            $where = "$tableName.jenjang!='' and $tableName.paralel='{$paralel}'";
        } elseif ($jenjang != "Semua" and $paralel == "Semua") {
            $where = "$tableName.jenjang='{$jenjang}'";
        } elseif ($jenjang != "Semua" and $paralel != "Semua") {
            $where = "$tableName.jenjang='{$jenjang}' and $tableName.paralel='{$paralel}'";
        } else {
            $where = "$tableName.jenjang!=''";
        };

        if ($jenis == "Semua") {
            $where_jenis = "and $tableName.jenis!=''";
        } else {
            $where_jenis = "and $tableName.jenis='{$jenis}'";
        };

        if ($status == "Semua") {
            $where_status = "";
        } else {
            $where_status = "and $tb_siswa.status='{$status}'";
        };

        $db = database::getInstance();
        $show = $db->runQuery("SELECT SUM(jumlah) As TOTAL FROM {$tableName} LEFT JOIN {$tb_siswa} ON " . $tb_siswa . ".nis = " . $tableName . ".nis  WHERE $where $where_jenis $where_status");
        $data = $show->fetch();
        $value = $data[0];
        return $value;

        //$belum = $crud->countData($tb_siswa . " LEFT JOIN db_induk_siswa ON " . $tb_siswa . ".nis = db_induk_siswa.nis", "where update_status='' && jenjang='$data->jenjang' && paralel='$data->paralel' && (" . $tb_siswa . ".status='Aktif' || " . $tb_siswa . ".status='Lulus')");
    }
    public function sumTerbayarKelas($tb_transaksi, $jenjang, $paralel) //Wali Kelas
    {
        $db = database::getInstance();
        $show = $db->runQuery("SELECT SUM(jumlah)  FROM {$tb_transaksi}  WHERE jenjang='{$jenjang}' and paralel='{$paralel}'");
        $data = $show->fetch();
        $value = $data[0];
        return $value;
    }
    public function sumTerbayarIf($tb_transaksi, $if) //Report Bulanan
    {
        $db = database::getInstance();
        $show = $db->runQuery("SELECT SUM(jumlah)  FROM {$tb_transaksi}  {$if}");
        $data = $show->fetch();
        $value = $data[0];
        return $value;
    }

    public function sumTerbayarOnPeriode($tableName, $jenjang, $paralel, $jenis, $bulan1, $bulan2) //report Rekapitulasi-1
    {
        if ($jenjang == "Semua" and $paralel == "Semua") {
            $where = "jenjang!=''";
        } elseif ($jenjang == "Semua" and $paralel != "Semua") {
            $where = "paralel='{$paralel}'";
        } elseif ($jenjang != "Semua" and $paralel == "Semua") {
            $where = "jenjang='{$jenjang}'";
        } elseif ($jenjang != "Semua" and $paralel != "Semua") {
            $where = "jenjang='{$jenjang}' and paralel='{$paralel}'";
        } else {
            $where = "jenjang!=''";
        };

        if ($jenis == "Semua") {
            $where_jenis = "and jenis!=''";
        } else {
            $where_jenis = "and jenis='{$jenis}'";
        };

        $db = database::getInstance();
        $show = $db->runQuery("SELECT SUM(jumlah)  FROM {$tableName}  WHERE $where $where_jenis and tahap>='$bulan1' and tahap<='$bulan2'");
        $data = $show->fetch();
        $value = $data[0];
        return $value;
    }


    public function infoterbayartotal($tableName, $nis)
    {
        $db = database::getInstance();
        $show = $db->runQuery("SELECT SUM(jumlah)  FROM {$tableName}  WHERE nis = '$nis'");
        $data = $show->fetch();
        $value = $data[0];

        if ($value == "" || $value  == 0) {
            $value = 0;
        } else {
            $value = $value;
        };

        return $value;
    }

    public function terbayarSpecify($tableName, $nis, $kode, $sifat, $tahun, $kelas)
    {
        $namaBayar = new namaBayar;
        $bulanan = $namaBayar->cekBulananx($tahun, $kode, $kelas);

        $db = database::getInstance();
        $show = $db->runQuery("SELECT SUM(jumlah)  FROM {$tableName}  WHERE nis = '$nis' and jenis ='{$kode}'");
        $data = $show->fetch();
        $value = $data[0];

        if ($sifat == $bulanan or $sifat == "Semua") {
            $value = $value;
        } else {
            $value = 0;
        };

        return $value;
    }

    public function terbayarSiswaSpecify($table, $nis, $sifat, $tahun, $kelas)
    {
        $a = $this->terbayarSpecify($table, $nis, 'A', $sifat, $tahun, $kelas);
        $b = $this->terbayarSpecify($table, $nis, 'B', $sifat, $tahun, $kelas);
        $c = $this->terbayarSpecify($table, $nis, 'C', $sifat, $tahun, $kelas);
        $d = $this->terbayarSpecify($table, $nis, 'D', $sifat, $tahun, $kelas);
        $e = $this->terbayarSpecify($table, $nis, 'E', $sifat, $tahun, $kelas);
        $f = $this->terbayarSpecify($table, $nis, 'F', $sifat, $tahun, $kelas);
        $g = $this->terbayarSpecify($table, $nis, 'G', $sifat, $tahun, $kelas);
        $h = $this->terbayarSpecify($table, $nis, 'H', $sifat, $tahun, $kelas);
        $i = $this->terbayarSpecify($table, $nis, 'I', $sifat, $tahun, $kelas);
        $j = $this->terbayarSpecify($table, $nis, 'J', $sifat, $tahun, $kelas);
        $k = $this->terbayarSpecify($table, $nis, 'K', $sifat, $tahun, $kelas);
        $l = $this->terbayarSpecify($table, $nis, 'L', $sifat, $tahun, $kelas);
        $m = $this->terbayarSpecify($table, $nis, 'M', $sifat, $tahun, $kelas);
        $n = $this->terbayarSpecify($table, $nis, 'N', $sifat, $tahun, $kelas);
        $o = $this->terbayarSpecify($table, $nis, 'O', $sifat, $tahun, $kelas);
        $p = $this->terbayarSpecify($table, $nis, 'P', $sifat, $tahun, $kelas);
        $q = $this->terbayarSpecify($table, $nis, 'Q', $sifat, $tahun, $kelas);
        $r = $this->terbayarSpecify($table, $nis, 'R', $sifat, $tahun, $kelas);
        $s = $this->terbayarSpecify($table, $nis, 'S', $sifat, $tahun, $kelas);
        $t = $this->terbayarSpecify($table, $nis, 'T', $sifat, $tahun, $kelas);
        $u = $this->terbayarSpecify($table, $nis, 'U', $sifat, $tahun, $kelas);
        $v = $this->terbayarSpecify($table, $nis, 'V', $sifat, $tahun, $kelas);
        $w = $this->terbayarSpecify($table, $nis, 'W', $sifat, $tahun, $kelas);
        $x = $this->terbayarSpecify($table, $nis, 'X', $sifat, $tahun, $kelas);
        $y = $this->terbayarSpecify($table, $nis, 'Y', $sifat, $tahun, $kelas);
        $z = $this->terbayarSpecify($table, $nis, 'Z', $sifat, $tahun, $kelas);

        $jumlah_tangg = @($a + $b + $c + $d + $e + $f + $g + $h + $i + $j + $k + $l + $m + $n + $o + $p + $q + $r + $s + $t + $u + $v + $w + $x + $y + $z);
        return $jumlah_tangg;
    }
    public function infoterbayarIf($table, $nis, $kode)
    {
        if ($kode == "Semua") {
            $value = $this->infoterbayartotal($table, $nis);
        } else {
            $value = $this->infoterbayar($table, $nis, $kode);
        }
        return $value;
    }

    public function cekOver($tahun, $tb_siswa, $tb_transaksi, $nis, $jenis, $jumlah)
    {
        require('layout/session.php');
        //$db = database::getInstance();
        $crud = new crudData();
        $siswa = $crud->editData($tb_siswa, 'nis', $nis);
        $data = $siswa->fetch(PDO::FETCH_OBJ);
        $nis = $data->nis;

        $field_tang = 'tang_' . $jenis;

        if ($data->{$field_tang} == "" || !is_numeric($data->{$field_tang})) {
            $val_tang = 0;
        } else {
            $val_tang = $data->{$field_tang};
        };

        $dt_jenis = new namaBayar();
        $jenises = $dt_jenis->NamaTransaksi('tb_nama_bayar', 'tp', $tahun, $data->jenjang, 'kode');
        $dataJenis = $jenises->fetch(PDO::FETCH_OBJ);
        $blok = $dataJenis->blok; //cek apakah diblok jika melebihi tanggungan
        $jenis = $dataJenis->kode;

        //Terbayar & Kurang
        //$classTrans = new transaksi();
        $terbayar = $this->infoterbayar($tb_transaksi, $nis, $jenis);

        $kurang = ($val_tang - $terbayar);
        if ($jumlah > $kurang && ($blok == "Ya" || $blok == "ya" || $blok == "")) {
            $cek = false;
        } else {
            $cek = true;
        };
        return $cek;
    }
    public function kurangBayar($tahun, $tb_siswa, $tb_transaksi, $nis, $jenis, $jumlah)
    {
        require('layout/session.php');
        //$db = database::getInstance();
        $crud = new crudData();
        $siswa = $crud->editData($tb_siswa, 'nis', $nis);
        $data = $siswa->fetch(PDO::FETCH_OBJ);
        $nis = $data->nis;

        $field_tang = 'tang_' . $jenis;

        if ($data->{$field_tang} == "" || !is_numeric($data->{$field_tang})) {
            $val_tang = 0;
        } else {
            $val_tang = $data->{$field_tang};
        };

        $dt_jenis = new namaBayar();
        $jenises = $dt_jenis->NamaTransaksi('tb_nama_bayar', 'tp', $tahun, $data->jenjang, 'kode');
        $dataJenis = $jenises->fetch(PDO::FETCH_OBJ);
        $blok = $dataJenis->blok; //cek apakah diblok jika melebihi tanggungan
        $jenis = $dataJenis->kode;

        //Terbayar & Kurang
        //$classTrans = new transaksi();
        $terbayar = $this->infoterbayar($tb_transaksi, $nis, $jenis);

        $kurang = ($val_tang - $terbayar);

        return $kurang;
    }
    public function save($tahun)
    {
        $direct = new toast();
        $crud = new crudData();
        $clssekolah = new sekolah;


        if (isset($_POST['save_transaksi'])) {

            $nis = htmlspecialchars($_POST['nis']);
            $id = htmlspecialchars($_POST['id']);
            $id_tr = htmlspecialchars($_POST['id_tr']);
            $jenis = $_POST['jenis'];

            $tahun_tabel = substr($tahun, 2, 2) . substr($tahun, 7, 2);

            $tb_siswa = "tb_siswa" . $tahun_tabel;
            $tb_transaksi = "db_transaksi" . $tahun_tabel;

            foreach ($jenis as $a => $jenises) {

                $s_jenis = $jenises;
                $s_jumlah =  (int)$_POST['jumlah'][$a];
                $jenisX =  htmlspecialchars(trim($_POST['jenis'][$a]));
                $s_catatan =  htmlspecialchars($_POST['catatan'][$a]);
                $s_quantity = htmlspecialchars($_POST['quantity'][$a]);

                if ($s_quantity > 1) {
                    $quantity = $s_quantity;
                } else {
                    $quantity = 1;
                }

                $jenjang = $crud->getValue($tb_siswa, " where nis='$nis'", 'jenjang');
                $blokJenis = $crud->getValue('tb_nama_bayar', " where tp='$tahun' and kode='$jenisX' and kelas='$jenjang'", 'blok');

                $field_tang = 'tang_' . $jenisX;

                if (!is_numeric($crud->getValue($tb_siswa, " where nis='$nis'", $field_tang)) || $crud->getValue($tb_siswa, " where nis='$nis'", $field_tang) == "") {
                    $tanggungan = 0;
                } else {
                    $tanggungan = (int)$crud->getValue($tb_siswa, " where nis='$nis'", $field_tang);
                };
                $terbayar = $this->infoterbayar($tb_transaksi, $nis, $jenisX);
                $kurang = $tanggungan - $terbayar;
                $jumlah_total = $s_jumlah * $s_quantity;

                if ($jumlah_total > $kurang && $blokJenis != "no") {
                    $blokx = 1;
                } else {
                    $blokx = 0;
                };

                for ($x = 0; $x < $quantity; $x++) {

                    if ($s_jumlah < 1 || $quantity < 1  || !is_numeric($s_jumlah) || $blokx == 1) {

                        continue;
                    } else {

                        $this->insertTransaksi($s_jenis, $s_jumlah, $s_catatan);
                    };
                }
            }


            echo $direct->redirectTR('toast', 'x', $id, $id_tr, $tahun, 'transaksi/transaksi_printpreview');


            // exit(0);
        } else {
            echo "";
        }
        return true;
    }

    public function saveTF($tahun, $id_billing)
    {
        $direct = new toast();
        $crud = new crudData();
        $clssekolah = new sekolah;
        $tahun_tabel = substr($tahun, 2, 2) . substr($tahun, 7, 2);

        $tb_siswa = "tb_siswa" . $tahun_tabel;
        $tb_transaksi = "db_transaksi" . $tahun_tabel;
        $payment_list = "payment_list" . $tahun_tabel;

        if (isset($_POST['save_transaksi'])) {

            $nis = htmlspecialchars($_POST['nis']);
            $id = htmlspecialchars($_POST['id']);
            $id_tr = htmlspecialchars($_POST['id_tr']);
            $jenis = $_POST['jenis'];



            foreach ($jenis as $a => $jenises) {

                $s_jenis = $jenises;
                $s_jumlah =  (int)$_POST['jumlah'][$a];
                $jenisX =  htmlspecialchars(trim($_POST['jenis'][$a]));
                $s_catatan =  htmlspecialchars($_POST['catatan'][$a]);
                $s_quantity = htmlspecialchars($_POST['quantity'][$a]);

                if ($s_quantity > 1) {
                    $quantity = $s_quantity;
                } else {
                    $quantity = 1;
                }

                $jenjang = $crud->getValue($tb_siswa, " where nis='$nis'", 'jenjang');
                $blokJenis = $crud->getValue('tb_nama_bayar', " where tp='$tahun' and kode='$jenisX' and kelas='$jenjang'", 'blok');

                $field_tang = 'tang_' . $jenisX;

                if (!is_numeric($crud->getValue($tb_siswa, " where nis='$nis'", $field_tang)) || $crud->getValue($tb_siswa, " where nis='$nis'", $field_tang) == "") {
                    $tanggungan = 0;
                } else {
                    $tanggungan = (int)$crud->getValue($tb_siswa, " where nis='$nis'", $field_tang);
                };
                $terbayar = $this->infoterbayar($tb_transaksi, $nis, $jenisX);
                $kurang = $tanggungan - $terbayar;
                $jumlah_total = $s_jumlah * $s_quantity;

                if ($jumlah_total > $kurang && $blokJenis != "no") {
                    $blokx = 1;
                } else {
                    $blokx = 0;
                };

                for ($x = 0; $x < $quantity; $x++) {

                    if ($s_jumlah < 1 || $quantity < 1  || !is_numeric($s_jumlah) || $blokx == 1) {

                        continue;
                    } else {

                        $this->insertTransaksi($s_jenis, $s_jumlah, $s_catatan);
                    };
                }
            }

            //Update Billing
            $dataarray = [
                'status' => 'PAID',
                'keterangan' => ''
            ];
            $update = $crud->updateData($payment_list, $dataarray, ['payment_id', ' = ', $id_billing]);
            $delete = $crud->deleteData('payment_list_detail', 'payment_id', $id_billing);

            echo $direct->redirectTR('toast', 'x', $id, $id_tr, $tahun, 'transaksi/transaksi_printpreview');


            // exit(0);
        } else {
            echo "";
        }
        return true;
    }

    public function insertTransaksi($jenis, $jumlah, $catatan)
    {
        require('layout/session.php');
        $ipnya = $this->IPnya();
        $brows = $_SERVER['HTTP_USER_AGENT'];
        date_default_timezone_set('Asia/Jakarta');

        $crud = new crudData();
        $time = new time;
        $format = new format;
        $waktu = $time->getTime();


        $nama_penerima = $crud->getValue('user', "where username='$username'", 'id');
        $nis = htmlspecialchars($_POST['nis']);
        $id_tr = htmlspecialchars($_POST['id_tr']);
        $startAt = htmlspecialchars($_POST['startAt']);
        $nama = htmlspecialchars($_POST['nama']);
        $kelamin = htmlspecialchars($_POST['kelamin']);
        $jenjang = htmlspecialchars($_POST['jenjang']);
        $paralel = htmlspecialchars($_POST['paralel']);
        $kategori = htmlspecialchars($_POST['kategori']);
        $metode = htmlspecialchars($_POST['metode']);
        $tanggal = $format->dateToEng($_POST['tanggal']);

        $random = new random;
        $randomx = strtoupper(substr(md5($waktu), 2, 5) . $random->create(5) . substr(md5($random->create(20)), 2, 2));
        $id = strtoupper(substr(md5($randomx), 4, 8) . $random->create(7) . substr(md5($random->create(20)), 5, 5));
        //Tahap
        $in_tahap = $this->tahap($tb_transaksi, $jenis, $nis, $startAt, $tahun, $jenis);
        $tgl_setor = "1900-01-01";


        $dataarray = [
            'tanggal' => $tanggal,
            'nis' => $nis,
            'nama' => $nama,
            'kelamin' => $kelamin,
            'jenjang' => $jenjang,
            'paralel' => $paralel,
            'kategori' => $kategori,
            'jenis' => $jenis,
            'tahap' => $in_tahap,
            'jumlah' => $jumlah,
            'random' => $randomx,
            'penerima' => $nama_penerima,
            'setor' => '',
            'id_setor' => '',
            'metode' => $metode,
            'catatan' => $catatan,
            'time' => $waktu,
            'ip' => $ipnya,
            'browser' => $brows,
            'id_tr' => $id_tr,
            'id' => $id
        ];
        $save = $crud->insertData($tb_transaksi, $dataarray);

        return $save;
    }

    public function ValPeriode($periode, $tahun1, $tahun2, $tahap)
    {

        if ($periode == '') {
            $value = 'Juli ' .
                $tahun1;
        } elseif ($periode == 1) {
            $value  = 'Juli ' .
                $tahun1;
        } elseif ($periode == 2) {
            $value  = 'Agustus ' .
                $tahun1;
        } elseif ($periode == 3) {
            $value = 'September '
                . $tahun1;
        } elseif ($periode == 4) {
            $value = 'Oktober ' .
                $tahun1;
        } elseif ($periode == 5) {
            $value = 'Nopember ' .
                $tahun1;
        } elseif ($periode == 6) {
            $value = 'Desember ' .
                $tahun1;
        } elseif ($periode == 7) {
            $value = 'Januari ' .
                $tahun2;
        } elseif ($periode == 8) {
            $value = 'Februari ' .
                $tahun2;
        } elseif ($periode == 9) {
            $value = 'Maret ' .
                $tahun2;
        } elseif ($periode == 10) {
            $value = 'April ' .
                $tahun2;
        } elseif ($periode == 11) {
            $value = 'Mei ' .
                $tahun2;
        } elseif ($periode == 12) {
            $value  = 'Juni ' .
                $tahun2;
        } else {
            $value = '##';
        };
        return $value;
    }

    public function cekPeriode($startAt, $tahap, $tahun1, $tahun2)
    {

        if ((int)$tahap > 12) {
            $value = $tahap;
        } else {
            $value = $this->ValPeriode($tahap, $tahun1, $tahun2, $tahap);
        }
        return $value;
    }

    public function jumlahKuitansi($tb_transaksi, $nis, $id_tr)
    {
        $db = database::getInstance();
        $show = $db->runQuery("SELECT SUM(jumlah)  FROM   {$tb_transaksi}  WHERE nis = '$nis' and id_tr='$id_tr'");
        $data = $show->fetch();
        $value = $data[0];
        return $value;
    }

    public function delPdf($folder, $name)
    {
        if (file_exists($folder . $name . ".pdf")) {
            $delPdf = unlink($folder . $name . ".pdf");
            $delQRCode = unlink($folder .  "qrcode.png");
            $delQRCodePdf = unlink($folder .  "qrcodepdf.png");
        } else {
            $delPdf = "";
            $delQRCode = unlink($folder .  "qrcode.png");
            $delQRCodePdf = unlink($folder .  "qrcodepdf.png");
        }
        // return $delPdf;
    }
}
