<?php

spl_autoload_register(function ($mod) {
    require('../../../bootstrap/asset/mod/' . $mod . '.php');
});

// Load file autoload.php
require '../../../bootstrap/asset/phpspreadsheet/autoload.php';


$tb_detail = $_GET['tb_detail'];

// Include librari PhpSpreadsheet
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();

// Buat sebuah variabel untuk menampung pengaturan style dari header tabel
$style_col = [
    'font' => ['bold' => true], // Set font nya jadi bold
    'font-family' => ['Arial'], // Set font nya jadi bold
    'alignment' => [
        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER, // Set text jadi ditengah secara horizontal (center)
        'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER // Set text jadi di tengah secara vertical (middle)
    ],
    'borders' => [
        'top' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN], // Set border top dengan garis tipis
        'right' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN],  // Set border right dengan garis tipis
        'bottom' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN], // Set border bottom dengan garis tipis
        'left' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN] // Set border left dengan garis tipis
    ]
];

// Buat sebuah variabel untuk menampung pengaturan style dari isi tabel
$style_row = [
    'alignment' => [
        'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER // Set text jadi di tengah secara vertical (middle)
    ],
    'borders' => [
        'top' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN], // Set border top dengan garis tipis
        'right' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN],  // Set border right dengan garis tipis
        'bottom' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN], // Set border bottom dengan garis tipis
        'left' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN] // Set border left dengan garis tipis
    ]
];


$sheet->getStyle('A1')->getFont()->setBold(true); // Set bold kolom A1
$sheet->getStyle('A1')->getFont()->setSize(15); // Set font size 15 untuk kolom A1
$sheet->getStyle('A1:J10000')->getFont()->setName('Arial');
$sheet->getStyle('A1:J10000')->getFont()->setSize(10); //

//for ($i = 'A'; $i !=  $sheet->getHighestColumn(); $i++) {
//    $sheet->getColumnDimension($i)->setAutoSize(TRUE);
//}

// Buat header tabel nya pada baris ke 3
$sheet->setCellValue('A5', 'KODE');
$sheet->setCellValue('B5', 'KAT');
$sheet->setCellValue('C5', 'KEG');
$sheet->setCellValue('D5', 'KOMP');
$sheet->setCellValue('E5', 'AKUN');
$sheet->setCellValue('F5', 'DETAIL/URAIAN');
$sheet->setCellValue('G5', 'VOL');
$sheet->setCellValue('H5', 'UNIT');
$sheet->setCellValue('I5', 'SATUAN');
$sheet->setCellValue('J5', 'TOTAL');


// Apply style header yang telah kita buat tadi ke masing-masing kolom header
$sheet->getStyle('A5:J5')->applyFromArray($style_col);
$spreadsheet->getActiveSheet()->getStyle('A5:J5')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB('d5dbdb');

// Set height baris ke 1, 2 dan 3
$sheet->getRowDimension('1')->setRowHeight(20);
$sheet->getRowDimension('2')->setRowHeight(20);
$sheet->getRowDimension('3')->setRowHeight(20);

$sheet->getColumnDimension('A')->setWidth(18);
$sheet->getColumnDimension('B')->setWidth(5);
$sheet->getColumnDimension('C')->setWidth(5);
$sheet->getColumnDimension('D')->setWidth(6);
$sheet->getColumnDimension('E')->setWidth(12);
$sheet->getColumnDimension('F')->setWidth(40);
$sheet->getColumnDimension('G')->setWidth(5);
$sheet->getColumnDimension('H')->setWidth(10);
$sheet->getColumnDimension('I')->setWidth(12);
$sheet->getColumnDimension('J')->setWidth(12);

// Buat query untuk menampilkan semua data siswa
$crud = new crudData();
$showSiswa = $crud->showTable($tb_detail);

$no = 1; // Untuk penomoran tabel, di awal set dengan 1
$row = 6; // Set baris pertama untuk isi tabel adalah baris ke 4
while ($data = $showSiswa->fetch(PDO::FETCH_OBJ)) {

    $kode = $data->kategori . '.' . $data->kegiatan . '.' . $data->komponen . '.' . $data->akun . '.' . $no;
    $sheet->setCellValue('A' . $row, $kode);
    $sheet->setCellValue('B' . $row, $data->kategori);
    $sheet->setCellValue('C' . $row, $data->kegiatan);
    $sheet->setCellValue('D' . $row, $data->komponen);
    $sheet->setCellValue('E' . $row, $data->akun);
    $sheet->setCellValue('F' . $row, $data->uraian);
    $sheet->setCellValue('G' . $row, $data->volume);
    $sheet->setCellValue('H' . $row, $data->unit);
    $sheet->setCellValue('I' . $row, $data->satuan);
    $sheet->setCellValue('J' . $row, $data->total);


    // Apply style row yang telah kita buat tadi ke masing-masing baris (isi tabel)
    $sheet->getStyle('A' . $row . ':J' . $row)->applyFromArray($style_row);


    $sheet->getStyle('A' . $row)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER); // Set text center untuk kolom No
    $sheet->getStyle('B' . $row)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER); // Set text center untuk kolom No
    $sheet->getStyle('C' . $row)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT); // Set text left untuk kolom NIS
    $sheet->getStyle('D' . $row)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER); // Set text center untuk kolom No

    $sheet->getRowDimension($row)->setRowHeight(20); // Set height tiap row


    $sheet->getStyle('I' . $row . ':J' . $row)
        ->getNumberFormat()
        ->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_NUMBER);


    $no++; // Tambah 1 setiap kali looping
    $row++; // Tambah 1 setiap kali looping
}


// Set orientasi kertas jadi LANDSCAPE
$sheet->getPageSetup()->setOrientation(\PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_PORTRAIT);

// Set judul file excel nya
$sheet->setTitle("RKAS");

// Proses file excel
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment; filename="RKAS.xlsx"'); // Set nama file excel nya
header('Cache-Control: max-age=0');

$writer = new Xlsx($spreadsheet);
$writer->save('php://output');
